/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.properties.editor.server;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.properties.editor.model.PropertyEditorCategory;
import org.uberfire.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.properties.editor.model.PropertyEditorType;
import org.uberfire.properties.editor.server.BeanPropertyEditorBuilder;
import org.uberfire.properties.editor.server.beans.ComplexPlanBean;
import org.uberfire.properties.editor.server.beans.SampleEnum;
import org.uberfire.properties.editor.server.beans.SamplePlanBean;
import org.uberfire.properties.editor.server.beans.UnknownTypesBean;

public class BeanPropertyEditorBuilderTest {
    @Test
    public void samplePlanBean_shouldGenerateCategory() throws ClassNotFoundException {
        BeanPropertyEditorBuilder builder = new BeanPropertyEditorBuilder();
        PropertyEditorCategory category = builder.extract("org.uberfire.properties.editor.server.beans.SamplePlanBean");
        Assert.assertTrue((!category.getFields().isEmpty() ? 1 : 0) != 0);
        this.assertProperty((PropertyEditorFieldInfo)category.getFields().get(0), "text1", PropertyEditorType.TEXT);
        this.assertProperty((PropertyEditorFieldInfo)category.getFields().get(1), "text2", PropertyEditorType.TEXT);
    }

    @Test(expected=BeanPropertyEditorBuilder.NullBeanException.class)
    public void noBean_shouldGenerateException() {
        BeanPropertyEditorBuilder builder = new BeanPropertyEditorBuilder();
        PropertyEditorCategory category = builder.extract(null);
    }

    @Test
    public void samplePlanBeanAndInstance_shouldGenerateCategoryAndValues() throws ClassNotFoundException {
        BeanPropertyEditorBuilder builder = new BeanPropertyEditorBuilder();
        PropertyEditorCategory category = builder.extract("org.uberfire.properties.editor.server.beans.SamplePlanBean", (Object)new SamplePlanBean("value1", "value2"));
        Assert.assertTrue((!category.getFields().isEmpty() ? 1 : 0) != 0);
        PropertyEditorFieldInfo field1 = (PropertyEditorFieldInfo)category.getFields().get(0);
        PropertyEditorFieldInfo fiedl2 = (PropertyEditorFieldInfo)category.getFields().get(1);
        this.assertProperty(field1, "text1", PropertyEditorType.TEXT, "value1");
        this.assertProperty(fiedl2, "text2", PropertyEditorType.TEXT, "value2");
    }

    @Test
    public void complexPlanBean_shouldGenerateCategory() throws ClassNotFoundException {
        BeanPropertyEditorBuilder builder = new BeanPropertyEditorBuilder();
        PropertyEditorCategory category = builder.extract("org.uberfire.properties.editor.server.beans.ComplexPlanBean");
        Assert.assertTrue((!category.getFields().isEmpty() ? 1 : 0) != 0);
        PropertyEditorFieldInfo text = (PropertyEditorFieldInfo)category.getFields().get(0);
        PropertyEditorFieldInfo bool = (PropertyEditorFieldInfo)category.getFields().get(1);
        PropertyEditorFieldInfo bool2 = (PropertyEditorFieldInfo)category.getFields().get(2);
        PropertyEditorFieldInfo integer = (PropertyEditorFieldInfo)category.getFields().get(3);
        PropertyEditorFieldInfo inti = (PropertyEditorFieldInfo)category.getFields().get(4);
        PropertyEditorFieldInfo lon = (PropertyEditorFieldInfo)category.getFields().get(5);
        PropertyEditorFieldInfo plong = (PropertyEditorFieldInfo)category.getFields().get(6);
        PropertyEditorFieldInfo enumSample = (PropertyEditorFieldInfo)category.getFields().get(7);
        ArrayList<String> enumValues = new ArrayList<String>();
        enumValues.add(SampleEnum.VALUE1.toString());
        enumValues.add(SampleEnum.VALUE2.toString());
        enumValues.add(SampleEnum.VALUE3.toString());
        this.assertProperty(text, "text", PropertyEditorType.TEXT);
        this.assertProperty(bool, "bool", PropertyEditorType.BOOLEAN);
        this.assertProperty(bool2, "bool2", PropertyEditorType.BOOLEAN);
        this.assertProperty(integer, "integ", PropertyEditorType.NATURAL_NUMBER);
        this.assertProperty(inti, "inti", PropertyEditorType.NATURAL_NUMBER);
        this.assertProperty(lon, "lon", PropertyEditorType.NATURAL_NUMBER);
        this.assertProperty(plong, "plong", PropertyEditorType.NATURAL_NUMBER);
        this.assertProperty(enumSample, "enumSample", PropertyEditorType.COMBO);
        this.assertEnumValues(enumSample, enumValues);
    }

    @Test
    public void complexPlanBean_shouldGenerateCategoryAndValues() throws ClassNotFoundException {
        BeanPropertyEditorBuilder builder = new BeanPropertyEditorBuilder();
        ComplexPlanBean instance = new ComplexPlanBean("texto", true, true, 1, 1, 1L, 1L, SampleEnum.VALUE2);
        PropertyEditorCategory category = builder.extract("org.uberfire.properties.editor.server.beans.ComplexPlanBean", (Object)instance);
        Assert.assertTrue((!category.getFields().isEmpty() ? 1 : 0) != 0);
        PropertyEditorFieldInfo text = (PropertyEditorFieldInfo)category.getFields().get(0);
        PropertyEditorFieldInfo bool = (PropertyEditorFieldInfo)category.getFields().get(1);
        PropertyEditorFieldInfo bool2 = (PropertyEditorFieldInfo)category.getFields().get(2);
        PropertyEditorFieldInfo integer = (PropertyEditorFieldInfo)category.getFields().get(3);
        PropertyEditorFieldInfo inti = (PropertyEditorFieldInfo)category.getFields().get(4);
        PropertyEditorFieldInfo lon = (PropertyEditorFieldInfo)category.getFields().get(5);
        PropertyEditorFieldInfo plong = (PropertyEditorFieldInfo)category.getFields().get(6);
        PropertyEditorFieldInfo enumSample = (PropertyEditorFieldInfo)category.getFields().get(7);
        ArrayList<String> enumValues = new ArrayList<String>();
        enumValues.add(SampleEnum.VALUE1.toString());
        enumValues.add(SampleEnum.VALUE2.toString());
        enumValues.add(SampleEnum.VALUE3.toString());
        this.assertProperty(text, "text", PropertyEditorType.TEXT, "texto");
        this.assertProperty(bool, "bool", PropertyEditorType.BOOLEAN, "true");
        this.assertProperty(bool2, "bool2", PropertyEditorType.BOOLEAN, "true");
        this.assertProperty(integer, "integ", PropertyEditorType.NATURAL_NUMBER, "1");
        this.assertProperty(inti, "inti", PropertyEditorType.NATURAL_NUMBER, "1");
        this.assertProperty(lon, "lon", PropertyEditorType.NATURAL_NUMBER, "1");
        this.assertProperty(plong, "plong", PropertyEditorType.NATURAL_NUMBER, "1");
        this.assertProperty(enumSample, "enumSample", PropertyEditorType.COMBO, "VALUE2");
        this.assertEnumValues(enumSample, enumValues);
    }

    @Test
    public void shouldNotGenerateUnhandledTypes() throws ClassNotFoundException {
        BeanPropertyEditorBuilder builder = new BeanPropertyEditorBuilder();
        PropertyEditorCategory category = builder.extract("org.uberfire.properties.editor.server.beans.UnknownTypesBean", (Object)new UnknownTypesBean());
        Assert.assertTrue((boolean)category.getFields().isEmpty());
        category = builder.extract("org.uberfire.properties.editor.server.beans.UnknownTypesBean");
        Assert.assertTrue((boolean)category.getFields().isEmpty());
    }

    private void assertEnumValues(PropertyEditorFieldInfo enumSample, List<String> enumValues) {
        Assert.assertEquals((long)enumValues.size(), (long)enumSample.getComboValues().size());
        for (int i = 0; i < enumValues.size(); ++i) {
            Assert.assertEquals(enumSample.getComboValues().get(i), (Object)enumValues.get(i));
        }
    }

    @Test
    public void nullValuesOnInstanceShouldGenerateEmptyStrings() throws ClassNotFoundException {
        BeanPropertyEditorBuilder builder = new BeanPropertyEditorBuilder();
        PropertyEditorCategory category = builder.extract("org.uberfire.properties.editor.server.beans.SamplePlanBean", (Object)new SamplePlanBean(null, null));
        Assert.assertTrue((!category.getFields().isEmpty() ? 1 : 0) != 0);
        PropertyEditorFieldInfo field1 = (PropertyEditorFieldInfo)category.getFields().get(0);
        PropertyEditorFieldInfo fiedl2 = (PropertyEditorFieldInfo)category.getFields().get(1);
        this.assertProperty(field1, "text1", PropertyEditorType.TEXT, "");
        this.assertProperty(fiedl2, "text2", PropertyEditorType.TEXT, "");
    }

    private void assertProperty(PropertyEditorFieldInfo fieldInfo, String label, PropertyEditorType type, String expectedValue) {
        this.assertProperty(fieldInfo, label, type);
        Assert.assertEquals((Object)expectedValue, (Object)fieldInfo.getCurrentStringValue());
    }

    private void assertProperty(PropertyEditorFieldInfo fieldInfo, String label, PropertyEditorType type) {
        Assert.assertEquals((Object)label, (Object)fieldInfo.getLabel());
        Assert.assertEquals((Object)type, (Object)fieldInfo.getType());
    }
}

