/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.list.GroupsList;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;

@Dependent
public class UserAssignedGroupsExplorer
extends UserAssignedEntitiesExplorer<Group>
implements IsWidget,
org.uberfire.ext.security.management.client.editor.user.UserAssignedGroupsExplorer {
    Event<OnRemoveUserGroupEvent> removeUserGroupEventEvent;

    @Inject
    public UserAssignedGroupsExplorer(ClientUserSystemManager userSystemManager, ConfirmBox confirmBox, GroupsList groupList, AssignedEntitiesExplorer view, Event<OnRemoveUserGroupEvent> removeUserGroupEventEvent) {
        super(userSystemManager, confirmBox, groupList, view);
        this.removeUserGroupEventEvent = removeUserGroupEventEvent;
    }

    @Override
    protected String getEmptyText() {
        return UsersManagementWidgetsConstants.INSTANCE.userHasNoGroups();
    }

    @Override
    protected String getEntityType() {
        return UsersManagementWidgetsConstants.INSTANCE.groupsAssigned();
    }

    @Override
    protected String getTitle() {
        return null;
    }

    @Override
    protected String getEntityId(Group entity) {
        return entity.getName();
    }

    @Override
    protected String getEntityName(Group entity) {
        return entity.getName();
    }

    @Override
    protected String getEnsureRemoveText() {
        return UsersManagementWidgetsConstants.INSTANCE.ensureRemoveGroupFromUser();
    }

    @Override
    protected boolean canAssignEntities() {
        boolean canAssignGroups = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_ASSIGN_GROUPS);
        return this.isEditMode && canAssignGroups;
    }

    @Override
    protected void open(User user) {
        Set userGroups = user.getGroups();
        for (Group group : userGroups) {
            if (this.userSystemManager.getConstrainedGroups().contains(group.getName())) continue;
            this.entities.add(group);
        }
        super.open(user);
    }

    @Override
    protected void doShow() {
        this.entitiesList.show(this.entities, this.getCallback());
    }

    @Override
    protected void removeEntity(String name) {
        Iterator groups = this.entities.iterator();
        while (groups.hasNext()) {
            Group g = (Group)groups.next();
            if (!g.getName().equals(name)) continue;
            groups.remove();
        }
        this.doShow();
        this.removeUserGroupEventEvent.fire((Object)new OnRemoveUserGroupEvent(this, name));
    }
}

