/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Group;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsMessages;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.ContextualEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class GroupViewerWorkflow
implements IsWidget {
    ClientUserSystemManager userSystemManager;
    Event<OnErrorEvent> errorEvent;
    ConfirmBox confirmBox;
    Event<NotificationEvent> workbenchNotification;
    Event<DeleteGroupEvent> deleteGroupEvent;
    GroupViewer groupViewer;
    public EntityWorkflowView view;
    Group group;
    protected final ErrorCallback<Message> errorCallback = new ErrorCallback<Message>(){

        public boolean error(Message message, Throwable throwable) {
            GroupViewerWorkflow.this.showError(throwable);
            return false;
        }
    };

    @Inject
    public GroupViewerWorkflow(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, ConfirmBox confirmBox, Event<NotificationEvent> workbenchNotification, Event<DeleteGroupEvent> deleteGroupEvent, GroupViewer groupViewer, EntityWorkflowView view) {
        this.userSystemManager = userSystemManager;
        this.errorEvent = errorEvent;
        this.confirmBox = confirmBox;
        this.workbenchNotification = workbenchNotification;
        this.deleteGroupEvent = deleteGroupEvent;
        this.groupViewer = groupViewer;
        this.view = view;
    }

    @PostConstruct
    public void setup() {
    }

    public void show(String name) {
        assert (name != null);
        this.clear();
        this.view.setWidget((IsWidget)this.groupViewer.asWidget()).setSaveButtonVisible(false).setSaveButtonEnabled(false).setCancelButtonVisible(false).setCallback(null);
        this.load(name, new Command(){

            public void execute() {
                GroupViewerWorkflow.this.groupViewer.show(GroupViewerWorkflow.this.group);
            }
        });
    }

    public void clear() {
        this.groupViewer.clear();
        this.view.clearNotification();
        this.group = null;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    void load(String name, final Command callback) {
        this.userSystemManager.groups((RemoteCallback)new RemoteCallback<Group>(){

            public void callback(Group group) {
                GroupViewerWorkflow.this.group = group;
                callback.execute();
            }
        }, this.errorCallback).get(name);
    }

    void delete() {
        final String name = this.group.getName();
        this.userSystemManager.groups((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void o) {
                GroupViewerWorkflow.this.deleteGroupEvent.fire((Object)new DeleteGroupEvent(name));
                GroupViewerWorkflow.this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsMessages.INSTANCE.groupRemoved(name), NotificationEvent.NotificationType.INFO));
                GroupViewerWorkflow.this.clear();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message o, Throwable throwable) {
                GroupViewerWorkflow.this.showError(throwable);
                return false;
            }
        }).delete(new String[]{name});
    }

    void onDeleteUserEvent(@Observes OnDeleteEvent onDeleteEvent) {
        if (this.checkEventContext(onDeleteEvent, this.groupViewer)) {
            this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.ensureRemoveGroup(), new Command(){

                public void execute() {
                    GroupViewerWorkflow.this.delete();
                }
            });
        }
    }

    protected boolean checkEventContext(ContextualEvent contextualEvent, Object context) {
        return contextualEvent != null && contextualEvent.getContext() != null && contextualEvent.getContext().equals(context);
    }

    protected void showError(Throwable throwable) {
        String msg = throwable != null ? throwable.getMessage() : UsersManagementWidgetsConstants.INSTANCE.genericError();
        this.errorEvent.fire((Object)new OnErrorEvent((Object)this, msg));
    }
}

