/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesEditor;
import org.uberfire.ext.security.management.client.widgets.management.explorer.AbstractEntityExplorer;
import org.uberfire.ext.security.management.client.widgets.management.explorer.ExplorerViewContext;
import org.uberfire.mvp.Command;

public abstract class UserAssignedEntitiesEditor<T>
implements IsWidget {
    ClientUserSystemManager userSystemManager;
    AbstractEntityExplorer<T> entitiesExplorer;
    public AssignedEntitiesEditor view;
    protected Set<T> entities = new LinkedHashSet<T>();
    protected boolean isEditMode;
    final Command closeEditorCallback = new Command(){

        public void execute() {
            UserAssignedEntitiesEditor.this.hide();
        }
    };
    final Command saveEditorCallback = new Command(){

        public void execute() {
            UserAssignedEntitiesEditor.this.hide();
            Set<String> selected = UserAssignedEntitiesEditor.this.entitiesExplorer.getSelectedEntities();
            UserAssignedEntitiesEditor.this.entities.clear();
            UserAssignedEntitiesEditor.this.onSave(selected);
            UserAssignedEntitiesEditor.this.entitiesExplorer.clear();
        }
    };

    @Inject
    public UserAssignedEntitiesEditor(ClientUserSystemManager userSystemManager, AbstractEntityExplorer<T> entitiesExplorer, AssignedEntitiesEditor view) {
        this.userSystemManager = userSystemManager;
        this.entitiesExplorer = entitiesExplorer;
        this.view = view;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    protected abstract String getCancelText();

    protected abstract String getAddText();

    protected abstract String getTitle();

    protected abstract String getEntityIdentifier(T var1);

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.configure(this.entitiesExplorer.view);
        this.view.configureClose(this.getCancelText(), this.closeEditorCallback);
        this.view.configureSave(this.getAddText(), this.saveEditorCallback);
        this.entitiesExplorer.setPageSize(10);
    }

    public void show(User user) {
        this.clear();
        this.isEditMode = false;
        this.open(user);
    }

    public void edit(User user) {
        this.clear();
        this.isEditMode = true;
        this.open(user);
    }

    public void flush() {
        assert (this.isEditMode);
    }

    public Set<T> getValue() {
        return this.entities;
    }

    public void setViolations(Set<ConstraintViolation<User>> constraintViolations) {
    }

    public void hide() {
        this.view.hide();
    }

    public void clear() {
        this.entitiesExplorer.clear();
        this.entities.clear();
    }

    protected ExplorerViewContext getViewContext() {
        return new ExplorerViewContext(){

            @Override
            public boolean canCreate() {
                return false;
            }

            @Override
            public boolean canRead() {
                return false;
            }

            @Override
            public boolean canDelete() {
                return false;
            }

            @Override
            public boolean canSelect() {
                return true;
            }

            @Override
            public Set<String> getSelectedEntities() {
                if (UserAssignedEntitiesEditor.this.entities != null && !UserAssignedEntitiesEditor.this.entities.isEmpty()) {
                    HashSet<String> result = new HashSet<String>(UserAssignedEntitiesEditor.this.entities.size());
                    for (Object entity : UserAssignedEntitiesEditor.this.entities) {
                        result.add(UserAssignedEntitiesEditor.this.getEntityIdentifier(entity));
                    }
                    return result;
                }
                return null;
            }

            @Override
            public Set<String> getConstrainedEntities() {
                return new HashSet<String>();
            }
        };
    }

    protected void open(User user) {
        assert (user != null);
        this.view.show(this.getTitle() + " " + user.getIdentifier());
    }

    protected void onSave(Set<String> selectedEntities) {
    }
}

