/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group;

import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupViewer;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class GroupViewerTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    @Mock
    EventSourceMock<OnDeleteEvent> onDeleteEvent;
    @Mock
    GroupViewer.View view;
    private GroupViewer tested;
    @Mock
    Group group;

    @Before
    public void setup() {
        Mockito.when((Object)this.userSystemManager.isGroupCapabilityEnabled((Capability)Matchers.any(Capability.class))).thenReturn((Object)true);
        Mockito.when((Object)this.group.getName()).thenReturn((Object)"group1");
        this.tested = new GroupViewer(this.userSystemManager, this.onDeleteEvent, this.view);
    }

    @Test
    public void testInit() {
        this.tested.init();
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.tested);
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setShowDeleteButton(Matchers.anyBoolean());
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Matchers.anyString());
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testClear() {
        this.tested.group = this.group;
        this.tested.clear();
        Assert.assertNull((Object)this.tested.group);
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setShowDeleteButton(Matchers.anyBoolean());
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Matchers.anyString());
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testShow() {
        this.tested.show(this.group);
        Assert.assertEquals((Object)this.group, (Object)this.tested.group);
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show("group1");
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setShowDeleteButton(true);
    }

    @Test
    public void testOnDelete() {
        this.tested.onDelete();
        ((EventSourceMock)Mockito.verify(this.onDeleteEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnDeleteEvent.class));
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setShowDeleteButton(Matchers.anyBoolean());
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Matchers.anyString());
        ((GroupViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }
}

