/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow.GroupViewerWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class GroupViewerWorkflowTest
extends AbstractSecurityManagementTest {
    @Mock
    EventSourceMock<OnErrorEvent> errorEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    EventSourceMock<DeleteGroupEvent> deleteGroupEvent;
    @Mock
    GroupViewer groupViewer;
    @Mock
    EntityWorkflowView view;
    private GroupViewerWorkflow tested;
    @Mock
    Group group;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.group.getName()).thenReturn((Object)"group1");
        Mockito.when((Object)this.view.setWidget((IsWidget)Matchers.any(IsWidget.class))).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.clearNotification()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class))).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCancelButtonVisible(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonEnabled(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonVisible(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonText(Matchers.anyString())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.showNotification(Matchers.anyString())).thenReturn((Object)this.view);
        Mockito.when((Object)this.groupsManagerService.get(Matchers.anyString())).thenReturn((Object)this.group);
        this.tested = new GroupViewerWorkflow(this.userSystemManager, this.errorEvent, this.confirmBox, (Event)this.workbenchNotification, this.deleteGroupEvent, this.groupViewer, this.view);
    }

    @Test
    public void testClear() {
        this.tested.group = this.group;
        this.tested.clear();
        Assert.assertNull((Object)this.tested.group);
        ((GroupViewer)Mockito.verify((Object)this.groupViewer, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupViewer)Mockito.verify((Object)this.groupViewer, (VerificationMode)Mockito.times((int)0))).show((Group)Matchers.any(Group.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotification();
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonEnabled(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(Matchers.anyString());
    }

    @Test
    public void testShow() {
        String name = "group1";
        this.tested.show("group1");
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCallback((EntityWorkflowView.Callback)Matchers.isNull(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotification();
        ((GroupViewer)Mockito.verify((Object)this.groupViewer, (VerificationMode)Mockito.times((int)1))).show(this.group);
        ((GroupViewer)Mockito.verify((Object)this.groupViewer, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testOnDeleteUserEvent() {
        OnDeleteEvent onDeleteEvent = (OnDeleteEvent)Mockito.mock(OnDeleteEvent.class);
        Mockito.when((Object)onDeleteEvent.getContext()).thenReturn((Object)this.groupViewer);
        ((ConfirmBox)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Command callback = (Command)invocationOnMock.getArguments()[2];
                callback.execute();
                return null;
            }
        }).when((Object)this.confirmBox)).show(Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class));
        this.tested.group = this.group;
        this.tested.onDeleteUserEvent(onDeleteEvent);
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class));
        ((EventSourceMock)Mockito.verify(this.deleteGroupEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(DeleteGroupEvent.class));
        ((EventSourceMock)Mockito.verify((Object)this.workbenchNotification, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
    }

    @Test
    public void testShowError() {
        Throwable error = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)error.getMessage()).thenReturn((Object)"error1");
        this.tested.showError(error);
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnErrorEvent.class));
    }

    private void assertNoViewCalls() {
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonEnabled(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearNotification();
    }
}

