/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Arrays;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.MultiplePermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitch;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeAddedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeRemovedEvent;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.mvp.Command;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.impl.PermissionGroupNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiplePermissionNodeEditorTest {
    @Mock
    MultiplePermissionNodeEditor.View view;
    @Mock
    PermissionSwitch.View permissionSwitchView;
    @Mock
    LiveSearchDropDown liveSearchDropDown;
    @Mock
    PermissionWidgetFactory widgetFactory;
    @Mock
    Event<PermissionChangedEvent> changedEvent;
    @Mock
    Event<PermissionNodeAddedEvent> nodeAddedEvent;
    @Mock
    Event<PermissionNodeRemovedEvent> nodeRemovedEvent;
    @Mock
    Permission permission1;
    @Mock
    Permission permission2;
    @Mock
    PermissionGroupNode permissionGroupNode;
    @Mock
    PermissionResourceNode permissionResourceNode;
    @Mock
    PermissionNode childNode1;
    @Mock
    PermissionNode childNode2;
    @Mock
    PermissionNodeEditor childEditor1;
    @Mock
    PermissionNodeEditor childEditor2;
    @Mock
    Command onChange;
    MultiplePermissionNodeEditor presenter;
    PermissionSwitch permissionSwitch1;
    PermissionSwitch permissionSwitch2;

    @Before
    public void setUp() {
        this.presenter = new MultiplePermissionNodeEditor(this.view, this.liveSearchDropDown, this.widgetFactory, this.changedEvent, this.nodeAddedEvent, this.nodeRemovedEvent);
        this.permissionSwitch1 = (PermissionSwitch)Mockito.spy((Object)new PermissionSwitch(this.permissionSwitchView));
        this.permissionSwitch2 = (PermissionSwitch)Mockito.spy((Object)new PermissionSwitch(this.permissionSwitchView));
        Mockito.when((Object)this.widgetFactory.createSwitch()).thenReturn((Object)this.permissionSwitch1, (Object[])new PermissionSwitch[]{this.permissionSwitch2});
        Mockito.when((Object)this.widgetFactory.createEditor(this.childNode1)).thenReturn((Object)this.childEditor1);
        Mockito.when((Object)this.widgetFactory.createEditor(this.childNode2)).thenReturn((Object)this.childEditor2);
        Mockito.when((Object)this.permission1.getResult()).thenReturn((Object)AuthorizationResult.ACCESS_DENIED);
        Mockito.when((Object)this.permission1.getName()).thenReturn((Object)"p1");
        Mockito.when((Object)this.permission2.getResult()).thenReturn((Object)AuthorizationResult.ACCESS_GRANTED);
        Mockito.when((Object)this.permission2.getName()).thenReturn((Object)"p2");
        Mockito.when((Object)this.permissionGroupNode.getNodeName()).thenReturn((Object)"r1");
        Mockito.when((Object)this.permissionGroupNode.getPermissionList()).thenReturn(Arrays.asList(this.permission1, this.permission2));
        Mockito.when((Object)this.permissionGroupNode.getPermissionGrantName(this.permission1)).thenReturn((Object)"grant1");
        Mockito.when((Object)this.permissionGroupNode.getPermissionDenyName(this.permission1)).thenReturn((Object)"deny1");
        Mockito.when((Object)this.permissionGroupNode.getPermissionGrantName(this.permission2)).thenReturn((Object)"grant2");
        Mockito.when((Object)this.permissionGroupNode.getPermissionDenyName(this.permission2)).thenReturn((Object)"deny2");
        Mockito.when((Object)this.permissionResourceNode.getNodeName()).thenReturn((Object)"r2");
        Mockito.when((Object)this.permissionResourceNode.getPermissionList()).thenReturn(Arrays.asList(this.permission1, this.permission2));
        Mockito.when((Object)this.permissionResourceNode.getPermissionGrantName(this.permission1)).thenReturn((Object)"grant1");
        Mockito.when((Object)this.permissionResourceNode.getPermissionDenyName(this.permission1)).thenReturn((Object)"deny1");
        Mockito.when((Object)this.permissionResourceNode.getPermissionGrantName(this.permission2)).thenReturn((Object)"grant2");
        Mockito.when((Object)this.permissionResourceNode.getPermissionDenyName(this.permission2)).thenReturn((Object)"deny2");
        ((PermissionGroupNode)Mockito.doAnswer(invocationOnMock -> {
            LoadCallback callback = (LoadCallback)invocationOnMock.getArguments()[0];
            callback.afterLoad(Arrays.asList(this.childNode1, this.childNode2));
            return null;
        }).when((Object)this.permissionGroupNode)).expand((LoadCallback)Mockito.any(LoadCallback.class));
        ((PermissionResourceNode)Mockito.doAnswer(invocationOnMock -> {
            LoadCallback callback = (LoadCallback)invocationOnMock.getArguments()[0];
            callback.afterLoad(Arrays.asList(this.childNode1, this.childNode2));
            return null;
        }).when((Object)this.permissionResourceNode)).expand((LoadCallback)Mockito.any(LoadCallback.class));
    }

    @Test
    public void testInitGroupNode() {
        this.presenter.edit((PermissionNode)this.permissionGroupNode);
        Assert.assertEquals((long)this.presenter.getChildEditors().size(), (long)2L);
        Assert.assertEquals((Object)this.presenter.getPermissionNode(), (Object)this.permissionGroupNode);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setNodeName("r1");
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNodeFullName(Mockito.anyString());
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addPermission(this.permissionSwitch1);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addPermission(this.permissionSwitch2);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch1)).init((String)Mockito.eq((Object)"grant1"), (String)Mockito.eq((Object)"deny1"), Mockito.eq((boolean)false), Mockito.eq((int)0));
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch2)).init((String)Mockito.eq((Object)"grant2"), (String)Mockito.eq((Object)"deny2"), Mockito.eq((boolean)true), Mockito.eq((int)0));
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setClearChildrenEnabled(false);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setAddChildEnabled(true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setChildSelector((IsWidget)Mockito.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.liveSearchDropDown});
    }

    @Test
    public void testInitResourceNode() {
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        Assert.assertEquals((long)this.presenter.getChildEditors().size(), (long)2L);
        Assert.assertEquals((Object)this.presenter.getPermissionNode(), (Object)this.permissionResourceNode);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setAddChildEnabled(true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setChildSelector((IsWidget)this.liveSearchDropDown);
    }

    @Test
    public void testExpandGroupNode() {
        this.presenter.edit((PermissionNode)this.permissionGroupNode);
        this.presenter.onNodeClick();
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addChildEditor(this.childEditor1, false);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addChildEditor(this.childEditor2, false);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setAddChildEnabled(false);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setAddChildEnabled(true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setChildSelector((IsWidget)Mockito.any());
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setClearChildrenEnabled(true);
        ((PermissionNodeEditor)Mockito.verify((Object)this.childEditor1)).edit(this.childNode1);
        ((PermissionNodeEditor)Mockito.verify((Object)this.childEditor2)).edit(this.childNode2);
    }

    @Test
    public void testExpandResourceNode() {
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        this.presenter.onNodeClick();
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addChildEditor(this.childEditor1, true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addChildEditor(this.childEditor2, true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setAddChildEnabled(true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setChildSelector((IsWidget)Mockito.any());
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setClearChildrenEnabled(true);
        ((PermissionNodeEditor)Mockito.verify((Object)this.childEditor1)).edit(this.childNode1);
        ((PermissionNodeEditor)Mockito.verify((Object)this.childEditor2)).edit(this.childNode2);
    }

    @Test
    public void testSwitchChange() {
        this.presenter.edit((PermissionNode)this.permissionGroupNode);
        this.permissionSwitch1.onChange();
        ((Permission)Mockito.verify((Object)this.permission1)).setResult((AuthorizationResult)Mockito.any());
        ((Event)Mockito.verify(this.changedEvent)).fire(Mockito.any());
    }
}

