/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl.node;

import java.util.ArrayList;
import java.util.List;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeEditor;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.PermissionNode;

public abstract class BasePermissionNodeEditor
implements PermissionNodeEditor {
    protected ACLEditor aclEditor = null;
    protected PermissionNode permissionNode;
    private PermissionNodeEditor parentEditor = null;
    private List<PermissionNodeEditor> childEditorList = new ArrayList<PermissionNodeEditor>();
    protected int width = 240;
    protected int leftMargin = 0;
    protected int treeLevel = 0;
    protected int padding = 15;

    @Override
    public ACLEditor getACLEditor() {
        return this.aclEditor;
    }

    @Override
    public void setACLEditor(ACLEditor aclEditor) {
        this.aclEditor = aclEditor;
    }

    @Override
    public PermissionNode getPermissionNode() {
        return this.permissionNode;
    }

    @Override
    public PermissionNodeEditor getParentEditor() {
        return this.parentEditor;
    }

    @Override
    public void setParentEditor(PermissionNodeEditor editor) {
        this.parentEditor = editor;
    }

    @Override
    public List<PermissionNodeEditor> getChildEditors() {
        return this.childEditorList;
    }

    @Override
    public void addChildEditor(PermissionNodeEditor editor) {
        editor.setParentEditor(this);
        this.childEditorList.add(editor);
    }

    @Override
    public void removeChildEditor(PermissionNodeEditor editor) {
        editor.setParentEditor(null);
        this.childEditorList.remove(editor);
    }

    @Override
    public boolean hasChildEditors() {
        return !this.childEditorList.isEmpty();
    }

    @Override
    public void clearChildEditors() {
        this.childEditorList.clear();
    }

    @Override
    public boolean isAnException(Permission permission) {
        for (Permission p : this.permissionNode.getPermissionList()) {
            if (!p.impliesName(permission)) continue;
            return !p.getResult().equals((Object)permission.getResult());
        }
        return false;
    }

    @Override
    public int getExceptionNumber(Permission permission) {
        int count = 0;
        for (PermissionNodeEditor nodeEditor : this.getChildEditors()) {
            if (nodeEditor.getPermissionNode() == null || nodeEditor.getPermissionNode().getPermissionList() == null) continue;
            for (Permission p : nodeEditor.getPermissionNode().getPermissionList()) {
                if (!permission.impliesName(p) || permission.getResult().equals((Object)p.getResult())) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int getTreeLevel() {
        return this.treeLevel;
    }

    @Override
    public void setTreeLevel(int treeLevel) {
        this.treeLevel = treeLevel;
        this.onNodePanelWidthChanged();
    }

    @Override
    public void setLeftMargin(int margin) {
        this.leftMargin = margin;
        this.onNodePanelWidthChanged();
    }

    @Override
    public int getNodePanelWidth() {
        return this.width - this.leftMargin - this.treeLevel * this.padding;
    }

    @Override
    public void onParentPermissionChanged(Permission permission, boolean on) {
    }

    @Override
    public void onChildPermissionChanged(PermissionNodeEditor childEditor, Permission permission, boolean on) {
    }

    protected void onPermissionChanged(Permission permission, boolean on) {
        if (this.parentEditor != null) {
            this.parentEditor.onChildPermissionChanged(this, permission, on);
        }
        for (PermissionNodeEditor child : this.getChildEditors()) {
            child.onParentPermissionChanged(permission, on);
        }
    }

    protected void onNodePanelWidthChanged() {
    }
}

