/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl.node;

import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.BasePermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionExceptionSwitch;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitch;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitchToogle;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionChangedEvent;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.PermissionNode;

@Dependent
public class LeafPermissionNodeEditor
extends BasePermissionNodeEditor {
    View view;
    PermissionWidgetFactory widgetFactory;
    Event<PermissionChangedEvent> permissionChangedEvent;
    Map<Permission, PermissionSwitchToogle> permissionSwitchMap = new HashMap<Permission, PermissionSwitchToogle>();

    @Inject
    public LeafPermissionNodeEditor(View view, PermissionWidgetFactory widgetFactory, Event<PermissionChangedEvent> permissionChangedEvent) {
        this.view = view;
        this.widgetFactory = widgetFactory;
        this.permissionChangedEvent = permissionChangedEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void edit(PermissionNode node) {
        this.permissionNode = node;
        this.permissionSwitchMap.clear();
        String name = node.getNodeName();
        String fullName = node.getNodeFullName();
        this.view.setNodeName(name);
        this.view.setNodePanelWidth(this.getNodePanelWidth());
        if (fullName != null && !fullName.equals(name)) {
            this.view.setNodeFullName(fullName);
        }
        PermissionNodeEditor parentEditor = this.getParentEditor();
        for (Permission permission : this.permissionNode.getPermissionList()) {
            PermissionSwitchToogle permissionSwitch;
            String grantName = node.getPermissionGrantName(permission);
            String denyName = node.getPermissionDenyName(permission);
            boolean granted = AuthorizationResult.ACCESS_GRANTED.equals((Object)permission.getResult());
            PermissionSwitchToogle switchToogle = null;
            if (parentEditor == null || parentEditor.getPermissionNode().getPermissionList().isEmpty()) {
                permissionSwitch = this.widgetFactory.createSwitch();
                ((PermissionSwitch)permissionSwitch).init(grantName, denyName, granted, 0);
                switchToogle = permissionSwitch;
            } else {
                permissionSwitch = this.widgetFactory.createExceptionSwitch();
                boolean isException = parentEditor.isAnException(permission);
                ((PermissionExceptionSwitch)permissionSwitch).init(grantName, denyName, granted, isException);
                switchToogle = permissionSwitch;
            }
            this.initPermissionSwitchToogle(switchToogle, permission);
            this.permissionSwitchMap.put(permission, switchToogle);
            this.view.addPermission(switchToogle);
        }
    }

    private void initPermissionSwitchToogle(PermissionSwitchToogle permissionSwitch, Permission permission) {
        permissionSwitch.setOnChange(() -> {
            permission.setResult(permissionSwitch.isOn() ? AuthorizationResult.ACCESS_GRANTED : AuthorizationResult.ACCESS_DENIED);
            this.onPermissionChanged(permission, permissionSwitch.isOn());
            this.permissionChangedEvent.fire((Object)new PermissionChangedEvent(this.getACLEditor(), permission, permissionSwitch.isOn()));
        });
    }

    @Override
    public void onParentPermissionChanged(Permission permission, boolean on) {
        for (Permission p : this.permissionSwitchMap.keySet()) {
            if (!permission.impliesName(p)) continue;
            PermissionSwitchToogle switchToogle = this.permissionSwitchMap.get(p);
            switchToogle.toogle();
        }
    }

    @Override
    protected void onNodePanelWidthChanged() {
        int width = this.getNodePanelWidth();
        this.view.setNodePanelWidth(width);
    }

    public static interface View
    extends UberView<LeafPermissionNodeEditor> {
        public void setNodeName(String var1);

        public void setNodePanelWidth(int var1);

        public void setNodeFullName(String var1);

        public void addPermission(PermissionSwitchToogle var1);
    }
}

