/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl.node;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.security.management.client.resources.i18n.SecurityManagementConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.MultiplePermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitch;

@Dependent
@Templated
public class MultiplePermissionNodeEditorView
extends Composite
implements MultiplePermissionNodeEditor.View {
    private MultiplePermissionNodeEditor presenter;
    @Inject
    @DataField
    Div rootPanel;
    @Inject
    @DataField
    Div headerPanel;
    @Inject
    @DataField
    org.jboss.errai.common.client.dom.Anchor nodeAnchor;
    @Inject
    @DataField
    Div nodeAnchorPanel;
    @Inject
    @DataField
    FlowPanel nodePermissions;
    @Inject
    @DataField
    Div collapsePanel;
    @Inject
    @DataField
    FlowPanel nodeChildren;
    @Inject
    @DataField
    org.jboss.errai.common.client.dom.Anchor addChildAnchor;
    @Inject
    @DataField
    org.jboss.errai.common.client.dom.Anchor clearChildrenAnchor;
    @Inject
    @DataField
    Div addChildPanel;
    @Inject
    @DataField
    Div clearChildrenPanel;
    @Inject
    @DataField
    org.jboss.errai.common.client.dom.Anchor cancelAnchor;
    @Inject
    @DataField
    FlowPanel childSelectorPanel;
    boolean expanded;
    boolean mouseOver;

    public void init(MultiplePermissionNodeEditor presenter) {
        this.presenter = presenter;
        String collapseId = Document.get().createUniqueId();
        this.collapsePanel.setId(collapseId);
        this.nodeAnchor.setHref("#" + collapseId);
        this.addChildAnchor.setTextContent(" " + SecurityManagementConstants.INSTANCE.addChildException());
        this.clearChildrenAnchor.setTextContent(" " + SecurityManagementConstants.INSTANCE.clearChildren());
    }

    @Override
    public void setNodeName(String name) {
        this.nodeAnchor.setTextContent(name);
    }

    @Override
    public void setNodePanelWidth(int width) {
        this.nodeAnchorPanel.getStyle().setProperty("width", width + "px");
    }

    @Override
    public void setNodeFullName(String name) {
        this.nodeAnchor.setTitle(name);
    }

    @Override
    public void setResourceName(String name) {
    }

    @Override
    public void addPermission(PermissionSwitch permissionSwitch) {
        this.nodePermissions.add((IsWidget)permissionSwitch);
    }

    @Override
    public void addChildEditor(PermissionNodeEditor editor, boolean dynamic) {
        if (dynamic) {
            editor.setLeftMargin(20);
            FlowPanel row = new FlowPanel();
            Anchor anchor = new Anchor();
            anchor.addStyleName("pf pficon-delete");
            anchor.getElement().getStyle().setWidth(20.0, Style.Unit.PX);
            anchor.getElement().getStyle().setDisplay(Style.Display.TABLE_CELL);
            anchor.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
            anchor.addClickHandler(event -> this.presenter.onRemoveChild(editor));
            editor.asWidget().getElement().getStyle().setDisplay(Style.Display.TABLE_CELL);
            editor.asWidget().getElement().getStyle().setProperty("paddingLeft", "0px");
            row.getElement().getStyle().setProperty("paddingLeft", "20px");
            row.add((Widget)anchor);
            row.add((IsWidget)editor);
            this.nodeChildren.add((Widget)row);
        } else {
            this.nodeChildren.add((IsWidget)editor);
        }
    }

    @Override
    public void addChildSeparator() {
        FlowPanel separator = new FlowPanel();
        separator.getElement().getStyle().setHeight(1.0, Style.Unit.PX);
        separator.getElement().getStyle().setBackgroundColor("lightgrey");
        this.nodeChildren.add((Widget)separator);
    }

    @Override
    public boolean hasChildren() {
        return this.nodeChildren.getWidgetCount() > 0;
    }

    @Override
    public void clearChildren() {
        this.nodeChildren.clear();
    }

    @Override
    public String getChildSelectorHint(String resourceName) {
        return SecurityManagementConstants.INSTANCE.selectResourceInstance(resourceName);
    }

    @Override
    public String getChildSearchHint(String resourceName) {
        return SecurityManagementConstants.INSTANCE.searchResourceInstance(resourceName);
    }

    @Override
    public String getChildrenNotFoundMsg(String resourceName) {
        return SecurityManagementConstants.INSTANCE.resourceInstanceNotFound(resourceName);
    }

    @Override
    public void setChildSelector(IsWidget childSelector) {
        this.childSelectorPanel.clear();
        this.childSelectorPanel.add(childSelector);
    }

    @Override
    public void showChildSelector() {
        this.addChildPanel.getStyle().removeProperty("display");
    }

    @Override
    public void hideChildSelector() {
        this.addChildPanel.getStyle().setProperty("display", "none");
    }

    @Override
    public void setAddChildEnabled(boolean enabled) {
        if (enabled) {
            this.addChildAnchor.getStyle().removeProperty("display");
        } else {
            this.addChildAnchor.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void setClearChildrenEnabled(boolean enabled) {
        if (enabled) {
            this.clearChildrenAnchor.getStyle().removeProperty("display");
        } else {
            this.clearChildrenAnchor.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.mouseOver = false;
        String rootPanelCss = expanded ? "root-panel-expanded" : "root-panel";
        String headerPanelCss = expanded ? "header-panel-expanded" : "header-panel";
        this.rootPanel.setAttribute("class", rootPanelCss);
        this.headerPanel.setAttribute("class", headerPanelCss);
    }

    @EventHandler(value={"nodeAnchor"})
    private void onNodeClick(ClickEvent event) {
        this.presenter.onNodeClick();
    }

    @EventHandler(value={"addChildAnchor"})
    private void onAddChild(ClickEvent event) {
        this.presenter.onAddChildStart();
    }

    @EventHandler(value={"clearChildrenAnchor"})
    private void onClearChildren(ClickEvent event) {
        this.presenter.onClearChildren();
    }

    @EventHandler(value={"cancelAnchor"})
    private void onCancelAdd(ClickEvent event) {
        this.presenter.onAddChildCancel();
    }

    @EventHandler(value={"headerPanel"})
    private void onHeaderMouseOver(MouseOverEvent event) {
        if (!this.expanded) {
            this.headerPanel.setAttribute("class", "header-panel-over");
            this.mouseOver = true;
        }
    }

    @EventHandler(value={"headerPanel"})
    private void onHeaderMouseOut(MouseOutEvent event) {
        if (this.mouseOver) {
            this.headerPanel.setAttribute("class", "header-panel");
            this.mouseOver = false;
        }
    }
}

