/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.list;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;

@Dependent
@Alternative
public class EntitiesList<T>
implements IsWidget {
    protected static final int DEFAULT_PAGE_SIZE = 5;
    LoadingBox loadingBox;
    public View view;
    int pageSize = 5;
    HeadingSize headingSize = HeadingSize.H3;
    Callback callback;
    PaginationConstraints paginationConstraints;
    int totalPages = -1;
    String emptyEntitiesText = null;

    @Inject
    public EntitiesList(LoadingBox loadingBox, View view) {
        this.loadingBox = loadingBox;
        this.view = view;
    }

    @PostConstruct
    protected void init() {
        this.view.init(this);
    }

    public void show(AbstractEntityManager.SearchResponse<T> response, Callback<T> callback) {
        if (callback != null && response != null) {
            this.show(response.getResults(), this.createPaginationCallback(response), callback);
        }
    }

    public void select(String identifier) {
        this.doSelectEntity(identifier, true);
    }

    public void unselect(String identifier) {
        this.doSelectEntity(identifier, false);
    }

    public void clear() {
        this.callback = null;
        this.paginationConstraints = null;
        this.totalPages = -1;
        this.emptyEntitiesText = null;
        this.view.clear();
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setEmptyEntitiesText(String emptyEntitiesText) {
        this.emptyEntitiesText = emptyEntitiesText;
    }

    public void setEntityTitleSize(HeadingSize headingSize) {
        this.headingSize = headingSize;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    String getEntityType() {
        return this.callback.getEntityType();
    }

    void onReadEntity(String identifier) {
        this.callback.onReadEntity(identifier);
    }

    void onRemoveEntity(String identifier) {
        this.callback.onRemoveEntity(identifier);
    }

    void onGoToFirstPage() {
        int currentPage = this.paginationConstraints.getCurrentPage();
        this.callback.onChangePage(currentPage, 1);
    }

    void onGoToPrevPage() {
        int currentPage = this.paginationConstraints.getCurrentPage();
        this.callback.onChangePage(currentPage, currentPage - 1);
    }

    void onGoToNextPage() {
        int currentPage = this.paginationConstraints.getCurrentPage();
        this.callback.onChangePage(currentPage, currentPage + 1);
    }

    void onGoToLastPage() {
        int currentPage = this.paginationConstraints.getCurrentPage();
        if (this.totalPages > 0) {
            this.callback.onChangePage(currentPage, this.totalPages + 1);
        }
    }

    void onSelectEntity(String identifier, int index, boolean isSelected) {
        this.doSelectEntity(identifier, isSelected);
    }

    private void doSelectEntity(String identifier, boolean isSelected) {
        this.callback.onSelectEntity(identifier, isSelected);
    }

    protected void show(Collection<T> entities, PaginationConstraints paginationConstraints, Callback<T> callback) {
        this.callback = callback;
        this.paginationConstraints = paginationConstraints;
        if (callback != null && entities != null) {
            this.showLoadingView();
            this.view.configure(this.emptyEntitiesText, paginationConstraints);
            if (!entities.isEmpty()) {
                int index = 0;
                for (T entity : entities) {
                    String id = callback.getIdentifier(entity);
                    String title = callback.getTitle(entity);
                    boolean isSelected = callback.isSelected(id);
                    this.view.add(index, id, title, this.headingSize, callback.canRead(), callback.canRemove(), callback.canSelect(), isSelected);
                    ++index;
                }
            }
            this.hideLoadingView();
        }
    }

    protected PaginationConstraints createPaginationCallback(AbstractEntityManager.SearchResponse searchResponse) {
        if (searchResponse != null) {
            final int page = searchResponse.getPage();
            final int total = searchResponse.getTotal();
            int totalPagesRounded = (int)Math.ceil((double)total / (double)searchResponse.getPageSize());
            int n = this.totalPages = total > -1 ? total / searchResponse.getPageSize() : -1;
            final boolean hasNextPage = this.totalPages > -1 ? page < totalPagesRounded : searchResponse.hasNextPage();
            final boolean notInFistPage = page > 1;
            final boolean isLastPageButtonEnabled = this.totalPages > -1 && hasNextPage;
            return new PaginationConstraints(){

                @Override
                public boolean isFirstPageEnabled() {
                    return notInFistPage;
                }

                @Override
                public boolean isFirstPageVisible() {
                    return notInFistPage;
                }

                @Override
                public boolean isPrevPageEnabled() {
                    return notInFistPage;
                }

                @Override
                public boolean isPrevPageVisible() {
                    return notInFistPage;
                }

                @Override
                public int getCurrentPage() {
                    return page;
                }

                @Override
                public boolean isNextPageEnabled() {
                    return hasNextPage;
                }

                @Override
                public boolean isNextPageVisible() {
                    return hasNextPage;
                }

                @Override
                public boolean isLastPageEnabled() {
                    return isLastPageButtonEnabled;
                }

                @Override
                public boolean isLastPageVisible() {
                    return isLastPageButtonEnabled;
                }

                @Override
                public Integer getTotal() {
                    return total > -1 ? Integer.valueOf(total) : null;
                }
            };
        }
        return null;
    }

    protected void showLoadingView() {
        this.loadingBox.show();
    }

    protected void hideLoadingView() {
        this.loadingBox.hide();
    }

    public static interface Callback<T> {
        public String getEntityType();

        public boolean canRead();

        public boolean canRemove();

        public boolean canSelect();

        public boolean isSelected(String var1);

        public String getIdentifier(T var1);

        public String getTitle(T var1);

        public void onReadEntity(String var1);

        public void onRemoveEntity(String var1);

        public void onSelectEntity(String var1, boolean var2);

        public void onChangePage(int var1, int var2);
    }

    public static interface PaginationConstraints {
        public boolean isFirstPageEnabled();

        public boolean isFirstPageVisible();

        public boolean isPrevPageEnabled();

        public boolean isPrevPageVisible();

        public int getCurrentPage();

        public boolean isNextPageEnabled();

        public boolean isNextPageVisible();

        public boolean isLastPageEnabled();

        public boolean isLastPageVisible();

        public Integer getTotal();
    }

    public static interface View
    extends UberView<EntitiesList> {
        public View configure(String var1, PaginationConstraints var2);

        public View add(int var1, String var2, String var3, HeadingSize var4, boolean var5, boolean var6, boolean var7, boolean var8);

        public View clear();
    }
}

