/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.list;

import java.util.Collection;
import java.util.List;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesListTest;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesPagedList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;

@RunWith(value=MockitoJUnitRunner.class)
public class EntitiesPagedListTest
extends EntitiesListTest {
    private EntitiesPagedList<User> presenter;
    private static final int PAGE_SIZE = 5;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.presenter = new EntitiesPagedList(this.loadingBox, this.view);
        this.presenter.setPageSize(5);
        this.presenter.setEntityTitleSize(this.headingSize);
        ((EntitiesListTest)this).presenter = this.presenter;
    }

    @Override
    @Test
    public void testClear() throws Exception {
        super.testClear();
        Assert.assertEquals((long)-1L, (long)this.presenter.currentPage);
    }

    @Override
    @Test
    public void testCreatePaginationCallbackSinglePage() throws Exception {
        this.presenter.totalPages = 1;
        this.presenter.currentPage = 1;
        EntitiesList.PaginationConstraints constraints = this.presenter.buildPaginationConstraints(10);
        Assert.assertFalse((boolean)constraints.isFirstPageEnabled());
        Assert.assertFalse((boolean)constraints.isFirstPageVisible());
        Assert.assertFalse((boolean)constraints.isPrevPageEnabled());
        Assert.assertFalse((boolean)constraints.isPrevPageVisible());
        Assert.assertFalse((boolean)constraints.isNextPageEnabled());
        Assert.assertFalse((boolean)constraints.isNextPageVisible());
        Assert.assertFalse((boolean)constraints.isLastPageEnabled());
        Assert.assertFalse((boolean)constraints.isLastPageVisible());
        Assert.assertEquals((long)constraints.getCurrentPage(), (long)1L);
    }

    @Test
    public void testCreatePaginationCallbackMultiplePages() throws Exception {
        this.presenter.totalPages = 5;
        this.presenter.currentPage = 2;
        EntitiesList.PaginationConstraints constraints = this.presenter.buildPaginationConstraints(10);
        Assert.assertTrue((boolean)constraints.isFirstPageEnabled());
        Assert.assertTrue((boolean)constraints.isFirstPageVisible());
        Assert.assertTrue((boolean)constraints.isPrevPageEnabled());
        Assert.assertTrue((boolean)constraints.isPrevPageVisible());
        Assert.assertTrue((boolean)constraints.isNextPageEnabled());
        Assert.assertTrue((boolean)constraints.isNextPageVisible());
        Assert.assertTrue((boolean)constraints.isLastPageEnabled());
        Assert.assertTrue((boolean)constraints.isLastPageVisible());
        Assert.assertEquals((long)constraints.getCurrentPage(), (long)2L);
    }

    @Test
    public void testShowFirstPage() throws Exception {
        int size = 10;
        List<User> entities = this.buildUsersList(10);
        this.testShowPage(entities, 1, 5);
    }

    @Test
    public void testShowSecondPage() throws Exception {
        int size = 10;
        List<User> entities = this.buildUsersList(10);
        this.testShowPage(entities, 2, 5);
    }

    protected void testShowPage(Collection<User> entities, int page, int pageSize) throws Exception {
        EntitiesList.Callback<User> callback = this.createEntitiesListCallback(entities, true, true, true);
        this.presenter.currentPage = page;
        this.presenter.show(entities, callback);
        Assert.assertEquals((Object)this.presenter.entities, entities);
        Assert.assertEquals((Object)this.presenter.callback, callback);
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((EntitiesList.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).configure(Matchers.anyString(), (EntitiesList.PaginationConstraints)Matchers.any(EntitiesList.PaginationConstraints.class));
        int start = pageSize * (page - 1);
        for (int x = 0; x < pageSize; ++x) {
            int pos = start + x;
            ((EntitiesList.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).add(x, this.getUserIdentifier(pos), this.getUserIdentifier(pos), this.headingSize, true, true, true, false);
        }
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
    }
}

