/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.form.validator.Validator;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.editor.HasRestrictedValues;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserAttributeEvent;

@Dependent
public class NewUserAttributeEditor
implements IsWidget,
HasRestrictedValues<Collection<String>> {
    Event<CreateUserAttributeEvent> createUserAttributeEventEvent;
    public View view;
    Collection<String> restrictedAttributeNames;
    final Validator<String> attributeNameValidator = new Validator<String>(){

        public int getPriority() {
            return 0;
        }

        public List<EditorError> validate(Editor<String> editor, String s) {
            ArrayList<EditorError> result = new ArrayList<EditorError>();
            String errorMsg = NewUserAttributeEditor.this.validateAttributeName(s);
            if (errorMsg != null) {
                EditorError e = NewUserAttributeEditor.this.view.createAttributeNameError(s, errorMsg);
                result.add(e);
            }
            return result;
        }
    };
    final Validator<String> attributeValueValidator = new Validator<String>(){

        public int getPriority() {
            return 1;
        }

        public List<EditorError> validate(Editor<String> editor, String s) {
            ArrayList<EditorError> result = new ArrayList<EditorError>();
            String errorMsg = NewUserAttributeEditor.this.validateAttributeValue(s);
            if (errorMsg != null) {
                EditorError e = NewUserAttributeEditor.this.view.createAttributeValueError(s, errorMsg);
                result.add(e);
            }
            return result;
        }
    };

    @Inject
    public NewUserAttributeEditor(View view, Event<CreateUserAttributeEvent> createUserAttributeEventEvent) {
        this.view = view;
        this.createUserAttributeEventEvent = createUserAttributeEventEvent;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.configure(this.attributeNameValidator, this.attributeValueValidator);
    }

    public NewUserAttributeEditor showAddButton() {
        this.view.reset().setShowAddButton(true).setShowForm(false);
        return this;
    }

    public NewUserAttributeEditor showForm() {
        this.view.reset().setShowAddButton(false).setShowForm(true);
        return this;
    }

    public NewUserAttributeEditor clear() {
        this.showAddButton();
        this.restrictedAttributeNames = null;
        return this;
    }

    public void setRestrictedValues(Collection<String> value) {
        this.restrictedAttributeNames = value;
    }

    void onNewAttributeClick() {
        this.showForm();
    }

    void onCancel() {
        this.showAddButton();
    }

    void addNewAttribute(String name, String value) {
        Map.Entry<String, String> attr = this.createAttributeEntry(name, value);
        this.createUserAttributeEventEvent.fire((Object)new CreateUserAttributeEvent(this, attr));
    }

    String validateAttributeName(String value) {
        if (this.isEmpty(value)) {
            return UsersManagementWidgetsConstants.INSTANCE.nameIsMandatory();
        }
        if (this.containsAttribute(value)) {
            return UsersManagementWidgetsConstants.INSTANCE.attributeAlreadyExists();
        }
        return null;
    }

    String validateAttributeValue(String value) {
        if (this.isEmpty(value)) {
            return UsersManagementWidgetsConstants.INSTANCE.valueIsMandatory();
        }
        return null;
    }

    private Map.Entry<String, String> createAttributeEntry(final String key, final String value) {
        return new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String setValue(String value2) {
                return null;
            }
        };
    }

    private boolean containsAttribute(String key) {
        return key != null && this.restrictedAttributeNames != null && this.restrictedAttributeNames.contains(key);
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static interface View
    extends UberView<NewUserAttributeEditor> {
        public View configure(Validator<String> var1, Validator<String> var2);

        public EditorError createAttributeNameError(String var1, String var2);

        public EditorError createAttributeValueError(String var1, String var2);

        public View reset();

        public View setShowAddButton(boolean var1);

        public View setShowForm(boolean var1);
    }
}

