/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.event.Event;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.user.UserEditorDriver;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.ChangePassword;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.ContextualEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveUserEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class BaseUserEditorWorkflow
implements IsWidget {
    public EntityWorkflowView view;
    protected ClientUserSystemManager userSystemManager;
    protected Event<OnErrorEvent> errorEvent;
    protected Event<NotificationEvent> workbenchNotification;
    protected Event<DeleteUserEvent> deleteUserEvent;
    protected Event<SaveUserEvent> saveUserEvent;
    protected ConfirmBox confirmBox;
    protected UserEditor userEditor;
    protected UserEditorDriver userEditorDriver;
    protected ChangePassword changePassword;
    protected LoadingBox loadingBox;
    protected final ErrorCallback<Message> errorCallback = new ErrorCallback<Message>(){

        public boolean error(Message message, Throwable throwable) {
            BaseUserEditorWorkflow.this.hideLoadingBox();
            BaseUserEditorWorkflow.this.showError(throwable);
            return false;
        }
    };
    protected User user;
    protected boolean isDirty;

    public BaseUserEditorWorkflow(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, Event<NotificationEvent> workbenchNotification, Event<DeleteUserEvent> deleteUserEvent, Event<SaveUserEvent> saveUserEvent, ConfirmBox confirmBox, UserEditor userEditor, UserEditorDriver userEditorDriver, ChangePassword changePassword, LoadingBox loadingBox, EntityWorkflowView view) {
        this.userSystemManager = userSystemManager;
        this.errorEvent = errorEvent;
        this.workbenchNotification = workbenchNotification;
        this.deleteUserEvent = deleteUserEvent;
        this.saveUserEvent = saveUserEvent;
        this.confirmBox = confirmBox;
        this.userEditor = userEditor;
        this.userEditorDriver = userEditorDriver;
        this.changePassword = changePassword;
        this.loadingBox = loadingBox;
        this.view = view;
        this.isDirty = false;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    protected void doShow(final String userId) {
        assert (userId != null);
        this.doShowEditorView();
        this.checkDirty(new Command(){

            public void execute() {
                BaseUserEditorWorkflow.this.clear();
                BaseUserEditorWorkflow.this.showLoadingBox();
                BaseUserEditorWorkflow.this.userSystemManager.users((RemoteCallback)new RemoteCallback<User>(){

                    public void callback(User o) {
                        BaseUserEditorWorkflow.this.hideLoadingBox();
                        BaseUserEditorWorkflow.this.user = o;
                        assert (BaseUserEditorWorkflow.this.user != null);
                        BaseUserEditorWorkflow.this.userEditorDriver.show(BaseUserEditorWorkflow.this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)BaseUserEditorWorkflow.this.userEditor);
                        BaseUserEditorWorkflow.this.view.setCancelButtonVisible(false);
                        BaseUserEditorWorkflow.this.view.setSaveButtonVisible(false);
                    }
                }, BaseUserEditorWorkflow.this.errorCallback).get(userId);
            }
        });
    }

    public void clear() {
        this.checkDirty(new Command(){

            public void execute() {
                BaseUserEditorWorkflow.this.doClear();
            }
        });
    }

    public UserEditor getUserEditor() {
        return this.userEditor;
    }

    protected void onSave() {
        this.doSave();
    }

    protected void onCancel() {
        this.doShow(this.user.getIdentifier());
    }

    protected void doShowEditorView() {
        this.view.setWidget((IsWidget)this.userEditor.view).setCancelButtonVisible(true).setSaveButtonVisible(true).setSaveButtonEnabled(this.isDirty).setSaveButtonText(this.getSaveButtonText()).setCallback(new EntityWorkflowView.Callback(){

            @Override
            public void onSave() {
                BaseUserEditorWorkflow.this.onSave();
            }

            @Override
            public void onCancel() {
                BaseUserEditorWorkflow.this.onCancel();
            }
        });
    }

    protected String getSaveButtonText() {
        return UsersManagementWidgetsConstants.INSTANCE.saveChanges();
    }

    protected void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.view.setSaveButtonEnabled(isDirty);
        if (isDirty) {
            this.view.showNotification(UsersManagementWidgetsConstants.INSTANCE.userModified(this.user.getIdentifier()));
        } else {
            this.view.clearNotification();
        }
    }

    protected void edit() {
        this.userEditorDriver.edit(this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)this.userEditor);
        this.view.setCancelButtonVisible(true);
        this.view.setSaveButtonEnabled(false);
        this.view.setSaveButtonVisible(true);
    }

    protected void doSave() {
        assert (this.user != null);
        boolean isValid = this.userEditorDriver.flush();
        this.user = this.userEditorDriver.getValue();
        if (!isValid) {
            throw new RuntimeException("User must be valid before updating it.");
        }
        RemoteCallback<User> assignGroupsCallback = new RemoteCallback<User>(){

            public void callback(final User user) {
                BaseUserEditorWorkflow.this.doAssignGroups(new Command(){

                    public void execute() {
                        BaseUserEditorWorkflow.this.doAssignRoles(new Command(){

                            public void execute() {
                                BaseUserEditorWorkflow.this.hideLoadingBox();
                                BaseUserEditorWorkflow.this.isDirty = false;
                                String id = user.getIdentifier();
                                BaseUserEditorWorkflow.this.afterSave(id);
                            }
                        });
                    }
                });
            }
        };
        this.showLoadingBox();
        this.doSaveRemoteServiceCall(assignGroupsCallback);
    }

    protected void doAssignGroups(final Command callback) {
        if (this.userEditor.canAssignGroups()) {
            this.userSystemManager.users((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void aVoid) {
                    callback.execute();
                }
            }, this.errorCallback).assignGroups(this.user.getIdentifier(), this.getGroupNames());
        } else {
            callback.execute();
        }
    }

    protected void doAssignRoles(final Command callback) {
        if (this.userEditor.canAssignRoles()) {
            this.userSystemManager.users((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void aVoid) {
                    callback.execute();
                }
            }, this.errorCallback).assignRoles(this.user.getIdentifier(), this.getRoleNames());
        } else {
            callback.execute();
        }
    }

    protected void doSaveRemoteServiceCall(RemoteCallback<User> callback) {
        this.userSystemManager.users(callback, this.errorCallback).update((Object)this.user);
    }

    protected void afterSave(String id) {
        this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.userSaved(id), NotificationEvent.NotificationType.SUCCESS));
        this.saveUserEvent.fire((Object)new SaveUserEvent(id));
        this.doShow(this.user.getIdentifier());
    }

    protected void doDelete() {
        if (this.user != null && this.user.getIdentifier() != null) {
            this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.ensureRemoveUser(), new Command(){

                public void execute() {
                    String id = BaseUserEditorWorkflow.this.user.getIdentifier();
                    BaseUserEditorWorkflow.this.showLoadingBox();
                    BaseUserEditorWorkflow.this.userSystemManager.users((RemoteCallback)new RemoteCallback<Void>(){

                        public void callback(Void o) {
                            BaseUserEditorWorkflow.this.hideLoadingBox();
                            String id = BaseUserEditorWorkflow.this.user.getIdentifier();
                            BaseUserEditorWorkflow.this.deleteUserEvent.fire((Object)new DeleteUserEvent(id));
                            BaseUserEditorWorkflow.this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.userRemoved(id), NotificationEvent.NotificationType.SUCCESS));
                            BaseUserEditorWorkflow.this.clear();
                        }
                    }, BaseUserEditorWorkflow.this.errorCallback).delete(new String[]{id});
                }
            }, new Command(){

                public void execute() {
                }
            });
        }
    }

    protected void doChangePassword() {
        this.showPasswordPopup(null);
    }

    protected void showPasswordPopup(ChangePassword.ChangePasswordCallback callback) {
        this.changePassword.show(this.user.getIdentifier(), callback);
    }

    protected Set<String> getGroupNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.user.getGroups().size());
        for (Group group : this.user.getGroups()) {
            result.add(group.getName());
        }
        return result;
    }

    protected Set<String> getRoleNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.user.getRoles().size());
        for (Role role : this.user.getRoles()) {
            result.add(role.getName());
        }
        return result;
    }

    protected void doClear() {
        this.view.clearNotification();
        this.userEditor.clear();
        this.user = null;
        this.setDirty(false);
    }

    protected boolean checkEventContext(ContextualEvent contextualEvent, Object context) {
        return contextualEvent != null && contextualEvent.getContext() != null && contextualEvent.getContext().equals(context);
    }

    protected void showError(Throwable throwable) {
        String msg = throwable != null ? throwable.getMessage() : UsersManagementWidgetsConstants.INSTANCE.genericError();
        this.showError(msg);
    }

    protected void showError(String message) {
        this.errorEvent.fire((Object)new OnErrorEvent((Object)this, message));
    }

    protected void checkDirty(Command callback) {
        if (this.isDirty) {
            this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.userIsDirty(), () -> {
                this.isDirty = false;
                callback.execute();
            }, () -> {});
        } else {
            callback.execute();
        }
    }

    protected void showLoadingBox() {
        this.loadingBox.show();
    }

    protected void hideLoadingBox() {
        this.loadingBox.hide();
    }
}

