/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Group;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementClientConstants;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.CreateEntity;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupUsersAssignment;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.AddUsersToGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class GroupCreationWorkflow
implements IsWidget {
    ClientUserSystemManager userSystemManager;
    Event<OnErrorEvent> errorEvent;
    ConfirmBox confirmBox;
    LoadingBox loadingBox;
    final ErrorCallback<Message> errorCallback = new ErrorCallback<Message>(){

        public boolean error(Message message, Throwable throwable) {
            GroupCreationWorkflow.this.loadingBox.hide();
            GroupCreationWorkflow.this.showError(throwable);
            return false;
        }
    };
    Event<NotificationEvent> workbenchNotification;
    CreateEntity createEntity;
    GroupUsersAssignment groupUsersAssignment;
    EntityWorkflowView view;
    Event<CreateGroupEvent> onCreateGroupEvent;
    Group group;

    @Inject
    public GroupCreationWorkflow(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, ConfirmBox confirmBox, LoadingBox loadingBox, Event<NotificationEvent> workbenchNotification, CreateEntity createEntity, GroupUsersAssignment groupUsersAssignment, Event<CreateGroupEvent> onCreateGroupEvent, EntityWorkflowView view) {
        this.userSystemManager = userSystemManager;
        this.errorEvent = errorEvent;
        this.confirmBox = confirmBox;
        this.loadingBox = loadingBox;
        this.createEntity = createEntity;
        this.groupUsersAssignment = groupUsersAssignment;
        this.workbenchNotification = workbenchNotification;
        this.onCreateGroupEvent = onCreateGroupEvent;
        this.view = view;
    }

    @PostConstruct
    public void init() {
    }

    public void create() {
        this.clear();
        this.view.setWidget((IsWidget)this.createEntity.asWidget()).setSaveButtonVisible(true).setSaveButtonEnabled(true).setSaveButtonText(UsersManagementWidgetsConstants.INSTANCE.next()).setCancelButtonVisible(false).setCallback(new EntityWorkflowView.Callback(){

            @Override
            public void onSave() {
                GroupCreationWorkflow.this.checkCreate();
            }

            @Override
            public void onCancel() {
                GroupCreationWorkflow.this.create();
            }
        });
        this.createEntity.show(UsersManagementWidgetsConstants.INSTANCE.inputGroupName(), UsersManagementWidgetsConstants.INSTANCE.groupName() + "...");
    }

    public void clear() {
        this.view.clearNotification();
        this.createEntity.clear();
        this.groupUsersAssignment.clear();
        this.group = null;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    protected void showUsersAssignment(String name) {
        assert (this.group != null);
        this.view.setWidget((IsWidget)this.groupUsersAssignment.asWidget()).setSaveButtonVisible(false).setSaveButtonEnabled(false).setSaveButtonText("").setCancelButtonVisible(true).setCallback(new EntityWorkflowView.Callback(){

            @Override
            public void onSave() {
            }

            @Override
            public void onCancel() {
                GroupCreationWorkflow.this.create();
            }
        });
        this.groupUsersAssignment.show(UsersManagementWidgetsConstants.INSTANCE.assignUsersToGroupName() + " " + name);
    }

    protected void checkCreate() {
        final String identifier = this.createEntity.getEntityIdentifier();
        if (identifier != null) {
            this.loadingBox.show();
            Collection constrainedGroups = this.userSystemManager.getConstrainedGroups();
            if (null != constrainedGroups && constrainedGroups.contains(identifier)) {
                this.loadingBox.hide();
                this.showErrorMessage(UsersManagementClientConstants.INSTANCE.roleAlreadyExists());
                this.createEntity.setErrorState();
            } else {
                this.userSystemManager.groups(o -> {
                    this.loadingBox.hide();
                    this.showErrorMessage(UsersManagementClientConstants.INSTANCE.groupAlreadyExists());
                    this.createEntity.setErrorState();
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message o, Throwable throwable) {
                        GroupCreationWorkflow.this.loadingBox.hide();
                        if (throwable instanceof GroupNotFoundException) {
                            GroupCreationWorkflow.this.createGroup(identifier);
                        } else {
                            GroupCreationWorkflow.this.showError(throwable);
                            GroupCreationWorkflow.this.create();
                        }
                        return false;
                    }
                }).get(identifier);
            }
        }
    }

    protected void createGroup(final String name) {
        Group _group = this.userSystemManager.createGroup(name);
        this.createEntity.clear();
        this.loadingBox.show();
        this.userSystemManager.groups((RemoteCallback)new RemoteCallback<Group>(){

            public void callback(Group group) {
                GroupCreationWorkflow.this.group = group;
                boolean isEmptyUsersAllowed = GroupCreationWorkflow.this.userSystemManager.getGroupManagerSettings().allowEmpty();
                GroupCreationWorkflow.this.loadingBox.hide();
                if (!isEmptyUsersAllowed) {
                    GroupCreationWorkflow.this.showUsersAssignment(name);
                } else {
                    GroupCreationWorkflow.this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.assignUsersToGroupName() + " " + name, new Command(){

                        public void execute() {
                            GroupCreationWorkflow.this.showUsersAssignment(name);
                        }
                    }, new Command(){

                        public void execute() {
                            GroupCreationWorkflow.this.fireGroupCreated(name);
                            GroupCreationWorkflow.this.create();
                        }
                    });
                }
            }
        }, this.errorCallback).create((Object)_group);
    }

    void onAssignUsers(@Observes AddUsersToGroupEvent addUsersToGroupEvent) {
        Object editor = addUsersToGroupEvent.getContext();
        if (editor != null && editor.equals(this.groupUsersAssignment)) {
            Set<String> users = addUsersToGroupEvent.getUsers();
            this.assignUsers(users);
        }
    }

    protected void assignUsers(Collection<String> users) {
        boolean isEmpty;
        assert (this.group != null);
        final String name = this.group.getName();
        boolean isEmptyUsersAllowed = this.userSystemManager.getGroupManagerSettings().allowEmpty();
        boolean bl = isEmpty = users == null || users.isEmpty();
        if (!isEmptyUsersAllowed && isEmpty) {
            this.showErrorMessage(UsersManagementWidgetsConstants.INSTANCE.groupMustHaveAtLeastOneUser());
            this.showUsersAssignment(name);
        } else {
            this.loadingBox.show();
            this.userSystemManager.groups((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void o) {
                    GroupCreationWorkflow.this.loadingBox.hide();
                    GroupCreationWorkflow.this.fireUsersAssigned(name);
                    GroupCreationWorkflow.this.create();
                }
            }, this.errorCallback).assignUsers(name, users);
        }
    }

    protected void fireGroupCreated(String name) {
        this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.groupCreated(name) + " " + name, NotificationEvent.NotificationType.INFO));
        this.onCreateGroupEvent.fire((Object)new CreateGroupEvent(name));
    }

    protected void fireUsersAssigned(String name) {
        this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.usersAssigned(name), NotificationEvent.NotificationType.INFO));
        this.onCreateGroupEvent.fire((Object)new CreateGroupEvent(name));
    }

    void showErrorMessage(String message) {
        this.showError((Throwable)new SecurityManagementException(message));
    }

    void showError(Throwable throwable) {
        this.errorEvent.fire((Object)new OnErrorEvent(this, throwable));
    }
}

