/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.NewUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.AbstractEntityExplorer;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;

@Dependent
public class UsersExplorer
extends AbstractEntityExplorer<User> {
    Event<ReadUserEvent> readUserEvent;
    Event<NewUserEvent> newUserEvent;

    @Inject
    public UsersExplorer(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, LoadingBox loadingBox, EntitiesList<User> entitiesList, EntitiesExplorerView view, Event<ReadUserEvent> readUserEvent, Event<NewUserEvent> newUserEvent) {
        super(userSystemManager, errorEvent, loadingBox, entitiesList, view);
        this.readUserEvent = readUserEvent;
        this.newUserEvent = newUserEvent;
    }

    @Override
    protected String getEmptyText() {
        return UsersManagementWidgetsConstants.INSTANCE.noUsers();
    }

    @Override
    protected String getEntityType() {
        return UsersManagementWidgetsConstants.INSTANCE.users();
    }

    @Override
    protected String getTitle() {
        return UsersManagementWidgetsConstants.INSTANCE.user();
    }

    @Override
    protected String getEntityId(User entity) {
        return entity.getIdentifier();
    }

    @Override
    protected String getEntityName(User entity) {
        return entity.getIdentifier();
    }

    @Override
    protected boolean canSearch() {
        return this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_SEARCH_USERS);
    }

    @Override
    protected boolean canCreate() {
        return this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_ADD_USER);
    }

    @Override
    protected boolean canRead() {
        return this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_READ_USER);
    }

    @Override
    protected void fireReadEvent(String identifier) {
        this.readUserEvent.fire((Object)new ReadUserEvent(identifier));
    }

    @Override
    protected void showCreate() {
        this.newUserEvent.fire((Object)new NewUserEvent());
    }

    @Override
    protected void showSearch() {
        this.showLoadingView();
        this.userSystemManager.users((RemoteCallback)new RemoteCallback<AbstractEntityManager.SearchResponse<User>>(){

            public void callback(AbstractEntityManager.SearchResponse<User> response) {
                EntitiesList.Callback callback = UsersExplorer.this.createCallback();
                UsersExplorer.this.entitiesList.show(response, callback);
                UsersExplorer.this.view.show(UsersExplorer.this.context, UsersExplorer.this.viewCallback);
                UsersExplorer.this.hideLoadingView();
            }
        }, this.errorCallback).search((AbstractEntityManager.SearchRequest)new SearchRequestImpl(this.searchPattern, this.currentPage, 15));
    }

    void onUserDeleted(@Observes DeleteUserEvent deleteUserEvent) {
        this.showSearch();
    }

    void onUserCreated(@Observes CreateUserEvent createUserEvent) {
        this.showSearch();
    }

    void onUserSaved(@Observes SaveUserEvent saveUserEvent) {
        this.showSearch();
    }
}

