/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Container;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.LabelType;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;

@Dependent
public class EntitiesExplorerViewImpl
extends Composite
implements EntitiesExplorerView {
    private static EntitiesExplorerViewImplBinder uiBinder = (EntitiesExplorerViewImplBinder)GWT.create(EntitiesExplorerViewImplBinder.class);
    @UiField
    FlowPanel mainPanel;
    @UiField
    Label mainLabel;
    @UiField
    Container mainContainer;
    @UiField
    Heading heading;
    @UiField
    Row searchRow;
    @UiField
    TextBox searchBox;
    @UiField
    Button searchButton;
    @UiField
    Button clearSearchButton;
    @UiField
    Button createButton;
    @UiField
    Button refreshButton;
    @UiField(provided=true)
    EntitiesList.View entitiesListView;
    private String entityType;
    private EntitiesExplorerView.ViewContext context;
    private EntitiesExplorerView.ViewCallback callback;

    @PostConstruct
    public void init() {
    }

    @Override
    public EntitiesExplorerView configure(String entityType, EntitiesList.View entitiesListView) {
        this.entitiesListView = entitiesListView;
        this.entityType = entityType;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.searchBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    EntitiesExplorerViewImpl.this.doSearch(EntitiesExplorerViewImpl.this.searchBox.getText());
                }
            }
        });
        this.searchButton.addClickHandler(e -> this.doSearch(this.searchBox.getText()));
        this.clearSearchButton.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                EntitiesExplorerViewImpl.this.doSearch("");
            }
        }, ClickEvent.getType());
        this.clearSearch();
        return this;
    }

    @Override
    public EntitiesExplorerView show(EntitiesExplorerView.ViewContext context, EntitiesExplorerView.ViewCallback callback) {
        this.clear();
        this.context = context;
        this.callback = callback;
        if (this.context.canSearch()) {
            this.searchRow.setVisible(true);
        }
        if (this.context.canCreate()) {
            this.createButton.setVisible(true);
            String createText = UsersManagementWidgetsConstants.INSTANCE.newEntity(this.entityType);
            this.createButton.setText(createText);
            this.createButton.setTitle(createText);
        }
        String searchForEntities = this.getTitleWithEntityType(UsersManagementWidgetsConstants.INSTANCE.searchFor(), true);
        this.searchButton.setTitle(searchForEntities);
        return this;
    }

    @Override
    public EntitiesExplorerView showMessage(LabelType labelType, String message) {
        this.clear();
        this.mainLabel.setText(message);
        this.mainLabel.setType(labelType);
        this.mainLabel.setVisible(true);
        this.mainContainer.setVisible(false);
        return this;
    }

    @Override
    public EntitiesExplorerView clearSearch() {
        String allEntitiesHeader = this.getTitleWithEntityType(UsersManagementWidgetsConstants.INSTANCE.all(), true);
        this.heading.setText(allEntitiesHeader);
        this.searchBox.setText("");
        this.searchBox.setPlaceholder(allEntitiesHeader);
        this.clearSearchButton.setEnabled(false);
        return this;
    }

    @Override
    public EntitiesExplorerView clear() {
        this.searchRow.setVisible(false);
        this.createButton.setVisible(false);
        this.context = null;
        this.callback = null;
        return this;
    }

    void doSearch(String pattern) {
        String pEsc = SafeHtmlUtils.htmlEscape((String)pattern);
        this.heading.setText(UsersManagementWidgetsConstants.INSTANCE.searchResultsFor() + " " + pEsc);
        this.clearSearchButton.setEnabled(true);
        if (this.callback != null) {
            this.callback.onSearch(pattern);
        }
    }

    private String getTitleWithEntityType(String text, boolean plural) {
        String t;
        String string = this.entityType != null ? (plural ? this.entityType + "s" : this.entityType) : (t = null);
        if (t != null) {
            return text + " " + t;
        }
        return text;
    }

    @UiHandler(value={"createButton"})
    public void onCreateButtonClick(ClickEvent event) {
        if (this.callback != null) {
            this.callback.onCreate();
        }
    }

    @UiHandler(value={"refreshButton"})
    public void onRefreshButtonClick(ClickEvent event) {
        if (this.callback != null) {
            this.callback.onRefresh();
        }
    }

    static interface EntitiesExplorerViewImplBinder
    extends UiBinder<FlowPanel, EntitiesExplorerViewImpl> {
    }
}

