/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.api.service.RoleManagerService;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.client.ClientSecurityExceptionMessageResolver;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractSecurityManagementTest {
    protected static final String ATTRIBUTE_USER_ID = "user.id";
    protected static final String ATTRIBUTE_USER_FIRST_NAME = "user.firstName";
    protected static final String ATTRIBUTE_USER_LAST_NAME = "user.lastName";
    protected static final String ATTRIBUTE_USER_ENABLED = "user.enabled";
    protected static final String ATTRIBUTE_USER_EMAIL = "user.email";
    @Mock
    protected EventSourceMock<NotificationEvent> workbenchNotification;
    @Mock
    protected UserManagerService userManagerService;
    @Mock
    protected GroupManagerService groupsManagerService;
    @Mock
    protected RoleManagerService rolesManagerService;
    @Mock
    protected ErrorPopupPresenter errorPopupPresenter;
    @Mock
    protected ClientSecurityExceptionMessageResolver exceptionMessageResolver;
    protected Caller<UserManagerService> usersManagerServiceCaller;
    protected Caller<GroupManagerService> groupsManagerServiceCaller;
    protected Caller<RoleManagerService> rolesManagerServiceCaller;
    protected ClientUserSystemManager userSystemManager;

    protected void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.usersManagerServiceCaller = new CallerMock((Object)this.userManagerService);
        this.groupsManagerServiceCaller = new CallerMock((Object)this.groupsManagerService);
        this.rolesManagerServiceCaller = new CallerMock((Object)this.rolesManagerService);
        this.userSystemManager = (ClientUserSystemManager)Mockito.spy((Object)new ClientUserSystemManager(this.usersManagerServiceCaller, this.groupsManagerServiceCaller, this.rolesManagerServiceCaller, this.exceptionMessageResolver, this.errorPopupPresenter));
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                String _id = (String)invocationOnMock.getArguments()[0];
                User user = AbstractSecurityManagementTest.this.mockUser(_id);
                return user;
            }
        }).when((Object)this.userSystemManager)).createUser(Mockito.anyString());
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<Group>(){

            public Group answer(InvocationOnMock invocationOnMock) throws Throwable {
                String _name = (String)invocationOnMock.getArguments()[0];
                Group group = (Group)Mockito.mock(Group.class);
                Mockito.when((Object)group.getName()).thenReturn((Object)_name);
                return group;
            }
        }).when((Object)this.userSystemManager)).createGroup(Mockito.anyString());
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<UserManager.UserAttribute>(){

            public UserManager.UserAttribute answer(InvocationOnMock invocationOnMock) throws Throwable {
                String _name = (String)invocationOnMock.getArguments()[0];
                Boolean _isMandatory = (Boolean)invocationOnMock.getArguments()[1];
                Boolean _isEditable = (Boolean)invocationOnMock.getArguments()[2];
                String _defaultValue = (String)invocationOnMock.getArguments()[3];
                UserManager.UserAttribute attribute = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
                Mockito.when((Object)attribute.getName()).thenReturn((Object)_name);
                Mockito.when((Object)attribute.isMandatory()).thenReturn((Object)_isMandatory);
                Mockito.when((Object)attribute.isEditable()).thenReturn((Object)_isEditable);
                Mockito.when((Object)attribute.getDefaultValue()).thenReturn((Object)_defaultValue);
                return attribute;
            }
        }).when((Object)this.userSystemManager)).createUserAttribute(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyString());
        Collection<UserManager.UserAttribute> userAttributes = this.getUserAttributes();
        ((ClientUserSystemManager)Mockito.doReturn((Object)true).when((Object)this.userSystemManager)).isUserCapabilityEnabled((Capability)Mockito.any(Capability.class));
        ((ClientUserSystemManager)Mockito.doReturn(userAttributes).when((Object)this.userSystemManager)).getUserSupportedAttributes();
        ((ClientUserSystemManager)Mockito.doReturn(userAttributes).when((Object)this.userSystemManager)).getUserSupportedAttributes();
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<UserManager.UserAttribute>(){

            public UserManager.UserAttribute answer(InvocationOnMock invocationOnMock) throws Throwable {
                return null;
            }
        }).when((Object)this.userSystemManager)).getUserSupportedAttribute(Mockito.anyString());
        ((ClientUserSystemManager)Mockito.doReturn((Object)true).when((Object)this.userSystemManager)).isGroupCapabilityEnabled((Capability)Mockito.any(Capability.class));
    }

    protected Map<Capability, CapabilityStatus> getUserCapabilities() {
        HashMap<Capability, CapabilityStatus> capabilities = new HashMap<Capability, CapabilityStatus>();
        capabilities.put(Capability.CAN_SEARCH_USERS, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_ADD_USER, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_UPDATE_USER, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_DELETE_USER, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_READ_USER, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_MANAGE_ATTRIBUTES, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_ASSIGN_GROUPS, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_CHANGE_PASSWORD, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_ASSIGN_ROLES, CapabilityStatus.UNSUPPORTED);
        return capabilities;
    }

    protected Map<Capability, CapabilityStatus> getGroupCapabilities() {
        HashMap<Capability, CapabilityStatus> capabilities = new HashMap<Capability, CapabilityStatus>();
        capabilities.put(Capability.CAN_SEARCH_GROUPS, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_ADD_GROUP, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_UPDATE_GROUP, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_DELETE_GROUP, CapabilityStatus.ENABLED);
        capabilities.put(Capability.CAN_READ_GROUP, CapabilityStatus.ENABLED);
        return capabilities;
    }

    protected Collection<UserManager.UserAttribute> getUserAttributes() {
        ArrayList<UserManager.UserAttribute> attributes = new ArrayList<UserManager.UserAttribute>();
        UserManager.UserAttribute USER_ID = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_ID.getName()).thenReturn((Object)ATTRIBUTE_USER_ID);
        Mockito.when((Object)USER_ID.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)USER_ID.isEditable()).thenReturn((Object)false);
        Mockito.when((Object)USER_ID.getDefaultValue()).thenReturn(null);
        attributes.add(USER_ID);
        UserManager.UserAttribute USER_FIST_NAME = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_FIST_NAME.getName()).thenReturn((Object)ATTRIBUTE_USER_FIRST_NAME);
        Mockito.when((Object)USER_FIST_NAME.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)USER_FIST_NAME.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)USER_FIST_NAME.getDefaultValue()).thenReturn((Object)"First name");
        attributes.add(USER_FIST_NAME);
        UserManager.UserAttribute USER_LAST_NAME = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_LAST_NAME.getName()).thenReturn((Object)ATTRIBUTE_USER_LAST_NAME);
        Mockito.when((Object)USER_LAST_NAME.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)USER_LAST_NAME.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)USER_LAST_NAME.getDefaultValue()).thenReturn((Object)"Last name");
        attributes.add(USER_LAST_NAME);
        UserManager.UserAttribute USER_ENABLED = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_ENABLED.getName()).thenReturn((Object)ATTRIBUTE_USER_ENABLED);
        Mockito.when((Object)USER_ENABLED.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)USER_ENABLED.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)USER_ENABLED.getDefaultValue()).thenReturn((Object)"true");
        attributes.add(USER_ENABLED);
        UserManager.UserAttribute USER_EMAIL = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)USER_EMAIL.getName()).thenReturn((Object)ATTRIBUTE_USER_EMAIL);
        Mockito.when((Object)USER_EMAIL.isMandatory()).thenReturn((Object)false);
        Mockito.when((Object)USER_EMAIL.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)USER_EMAIL.getDefaultValue()).thenReturn((Object)"");
        attributes.add(USER_EMAIL);
        return attributes;
    }

    protected List<User> buildUsersList(int size) {
        ArrayList<User> users = new ArrayList<User>();
        for (int x = 0; x < size; ++x) {
            User user = this.mockUser(this.getUserIdentifier(x));
            Mockito.when((Object)user.getIdentifier()).thenReturn((Object)this.getUserIdentifier(x));
            users.add(user);
        }
        return users;
    }

    protected List<Group> buildGroupsList(int size) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (int x = 0; x < size; ++x) {
            Group g = (Group)Mockito.mock(Group.class);
            Mockito.when((Object)g.getName()).thenReturn((Object)this.getGroupIdentifier(x));
            groups.add(g);
        }
        return groups;
    }

    protected List<Role> buildRolesList(int size) {
        ArrayList<Role> groups = new ArrayList<Role>();
        for (int x = 0; x < size; ++x) {
            Role g = (Role)Mockito.mock(Role.class);
            Mockito.when((Object)g.getName()).thenReturn((Object)this.getRoleIdentifier(x));
            groups.add(g);
        }
        return groups;
    }

    protected Collection<String> buildGroupIdsList(int size) {
        ArrayList<String> groups = new ArrayList<String>();
        for (int x = 0; x < size; ++x) {
            groups.add(this.getGroupIdentifier(x));
        }
        return groups;
    }

    public User mockUser(String id) {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)id);
        return user;
    }

    public Group mockGroup(String name) {
        Group g = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)g.getName()).thenReturn((Object)name);
        return g;
    }

    protected String getUserIdentifier(int x) {
        return "user" + x;
    }

    protected String getGroupIdentifier(int x) {
        return "group" + x;
    }

    protected String getRoleIdentifier(int x) {
        return "role" + x;
    }
}

