/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.events.RemoveUserGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.UserGroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.management.list.GroupsList;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserGroupsExplorerTest
extends AbstractSecurityManagementTest {
    @Mock
    GroupsList groupList;
    @Mock
    UserGroupsExplorer.View view;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    EventSourceMock<RemoveUserGroupEvent> removeUserGroupEventEvent;
    private UserGroupsExplorer presenter;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.presenter = new UserGroupsExplorer(this.groupList, this.view, this.confirmBox, this.removeUserGroupEventEvent);
        junit.framework.Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testClear() throws Exception {
        this.presenter.clear();
        Assert.assertFalse((boolean)this.presenter.canRemove);
        ((UserGroupsExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void show() {
        boolean canRemove = false;
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>(this.buildGroupsList(10));
        this.presenter.show(new HashSet<Group>(groups), false);
        Assert.assertFalse((boolean)this.presenter.canRemove);
        ((UserGroupsExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ArgumentCaptor responseArgumentCaptor = ArgumentCaptor.forClass(Set.class);
        ArgumentCaptor callbackArgumentCaptor = ArgumentCaptor.forClass(EntitiesList.Callback.class);
        ((GroupsList)Mockito.verify((Object)this.groupList, (VerificationMode)Mockito.times((int)1))).show((Collection)responseArgumentCaptor.capture(), (EntitiesList.Callback)callbackArgumentCaptor.capture());
        Set responseArgumentCaptured = (Set)responseArgumentCaptor.getValue();
        junit.framework.Assert.assertEquals(groups, (Object)responseArgumentCaptured);
        EntitiesList.Callback callbackArgumentCaptured = (EntitiesList.Callback)callbackArgumentCaptor.getValue();
        junit.framework.Assert.assertEquals((boolean)false, (boolean)callbackArgumentCaptured.canRead());
        junit.framework.Assert.assertEquals((boolean)false, (boolean)callbackArgumentCaptured.canRemove());
        junit.framework.Assert.assertEquals((boolean)false, (boolean)callbackArgumentCaptured.canSelect());
        int x = 0;
        for (Group _group : groups) {
            String gname = this.getGroupIdentifier(x);
            junit.framework.Assert.assertEquals((String)gname, (String)callbackArgumentCaptured.getIdentifier((Object)_group));
            junit.framework.Assert.assertEquals((String)gname, (String)callbackArgumentCaptured.getTitle((Object)_group));
            junit.framework.Assert.assertEquals((boolean)false, (boolean)callbackArgumentCaptured.isSelected(_group.getName()));
            ++x;
        }
    }
}

