/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.LeafPermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitch;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitchToogle;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionChangedEvent;
import org.uberfire.mvp.Command;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;

@RunWith(value=MockitoJUnitRunner.class)
public class LeafPermissionNodeEditorTest {
    @Mock
    LeafPermissionNodeEditor.View view;
    @Mock
    PermissionSwitch.View permissionSwitchView1;
    @Mock
    PermissionSwitch.View permissionSwitchView2;
    @Mock
    PermissionWidgetFactory widgetFactory;
    @Mock
    Event<PermissionChangedEvent> changedEvent;
    @Mock
    Permission permission1;
    @Mock
    Permission permission2;
    @Mock
    Command onChange;
    LeafPermissionNodeEditor presenter;
    PermissionSwitch permissionSwitch1;
    PermissionSwitch permissionSwitch2;
    PermissionLeafNode permissionNode;

    @Before
    public void setUp() {
        this.presenter = new LeafPermissionNodeEditor(this.view, this.widgetFactory, this.changedEvent);
        this.permissionSwitch1 = (PermissionSwitch)Mockito.spy((Object)new PermissionSwitch(this.permissionSwitchView1));
        this.permissionSwitch2 = (PermissionSwitch)Mockito.spy((Object)new PermissionSwitch(this.permissionSwitchView2));
        Mockito.when((Object)this.widgetFactory.createSwitch()).thenReturn((Object)this.permissionSwitch1, (Object[])new PermissionSwitch[]{this.permissionSwitch2});
        Mockito.when((Object)this.permission1.getResult()).thenReturn((Object)AuthorizationResult.ACCESS_DENIED);
        Mockito.when((Object)this.permission1.getName()).thenReturn((Object)"p1");
        Mockito.when((Object)this.permission2.getResult()).thenReturn((Object)AuthorizationResult.ACCESS_GRANTED);
        Mockito.when((Object)this.permission2.getName()).thenReturn((Object)"p2");
        this.permissionNode = new PermissionLeafNode();
        this.permissionNode.setNodeName("r1");
        this.permissionNode.addPermission(this.permission1, "grant1", "deny1");
        this.permissionNode.addPermission(this.permission2, "grant2", "deny2");
    }

    @Test
    public void testInit() {
        this.presenter.edit((PermissionNode)this.permissionNode);
        Assert.assertTrue((boolean)this.presenter.getChildEditors().isEmpty());
        Assert.assertEquals((Object)this.presenter.getPermissionNode(), (Object)this.permissionNode);
        ((LeafPermissionNodeEditor.View)Mockito.verify((Object)this.view)).setNodeName("r1");
        ((LeafPermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNodeFullName(Mockito.anyString());
        ((LeafPermissionNodeEditor.View)Mockito.verify((Object)this.view)).addPermission((PermissionSwitchToogle)this.permissionSwitch1);
        ((LeafPermissionNodeEditor.View)Mockito.verify((Object)this.view)).addPermission((PermissionSwitchToogle)this.permissionSwitch2);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch1)).init((String)Mockito.eq((Object)"grant1"), (String)Mockito.eq((Object)"deny1"), Mockito.eq((boolean)false), Mockito.eq((int)0));
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch2)).init((String)Mockito.eq((Object)"grant2"), (String)Mockito.eq((Object)"deny2"), Mockito.eq((boolean)true), Mockito.eq((int)0));
    }

    @Test
    public void testSwitchChange() {
        this.presenter.edit((PermissionNode)this.permissionNode);
        this.permissionSwitch1.onChange();
        ((Permission)Mockito.verify((Object)this.permission1)).setResult((AuthorizationResult)Mockito.any());
        ((Event)Mockito.verify(this.changedEvent)).fire(Mockito.any());
    }

    @Test
    public void testSwitchInitDependencies() {
        Mockito.when((Object)this.permissionSwitchView1.isOn()).thenReturn((Object)false);
        Mockito.reset((Object[])new Permission[]{this.permission2});
        this.permissionNode.addDependencies(this.permission1, new Permission[]{this.permission2});
        this.presenter.edit((PermissionNode)this.permissionNode);
        ((Permission)Mockito.verify((Object)this.permission2)).setResult(AuthorizationResult.ACCESS_DENIED);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch2)).setEnabled(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch2)).setOn(false);
    }

    @Test
    public void testSwitchChangeDependencies() {
        this.permissionNode.addDependencies(this.permission1, new Permission[]{this.permission2});
        this.presenter.edit((PermissionNode)this.permissionNode);
        Mockito.reset((Object[])new Permission[]{this.permission2});
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitch2});
        Mockito.when((Object)this.permissionSwitch1.isOn()).thenReturn((Object)false);
        this.permissionSwitch1.onChange();
        ((Permission)Mockito.verify((Object)this.permission2)).setResult(AuthorizationResult.ACCESS_DENIED);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch2)).setEnabled(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch2)).setOn(false);
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitch2});
        Mockito.when((Object)this.permissionSwitch1.isOn()).thenReturn((Object)true);
        this.permissionSwitch1.onChange();
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch2)).setEnabled(true);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitch2, (VerificationMode)Mockito.never())).setOn(Mockito.anyBoolean());
    }
}

