/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesEditor;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserRolesEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.explorer.ExplorerViewContext;
import org.uberfire.ext.security.management.client.widgets.management.explorer.RolesExplorer;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserAssignedRolesEditorTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    @Mock
    EventSourceMock<OnUpdateUserRolesEvent> updateUserRolesEvent;
    @Mock
    RolesExplorer rolesExplorer;
    @Mock
    AssignedEntitiesEditor<UserAssignedRolesEditor> view;
    @Mock
    User user;
    private UserAssignedRolesEditor tested;

    @Before
    public void setup() {
        HashMap<String, String> userAttributes = new HashMap<String, String>(1);
        userAttributes.put("attr1", "value1");
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.user.getProperties()).thenReturn(userAttributes);
        HashSet<Role> roles = new HashSet<Role>();
        Role role = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)role.getName()).thenReturn((Object)"role1");
        roles.add(role);
        Mockito.when((Object)this.user.getRoles()).thenReturn(roles);
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<Role>(){

            public Role answer(InvocationOnMock invocationOnMock) throws Throwable {
                Role _role = (Role)Mockito.mock(Role.class);
                return _role;
            }
        }).when((Object)this.userSystemManager)).createRole(ArgumentMatchers.anyString());
        this.tested = new UserAssignedRolesEditor(this.userSystemManager, this.rolesExplorer, this.view, this.updateUserRolesEvent);
    }

    @Test
    public void testInit() {
        this.tested.init();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.tested);
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).configure((EntitiesExplorerView)ArgumentMatchers.any());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((RolesExplorer)Mockito.verify((Object)this.rolesExplorer, (VerificationMode)Mockito.times((int)1))).setPageSize(ArgumentMatchers.anyInt());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).hide();
    }

    @Test
    public void testClear() {
        this.tested.clear();
        ((RolesExplorer)Mockito.verify((Object)this.rolesExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        Assert.assertTrue((boolean)this.tested.entities.isEmpty());
        this.assertNoViewCalls();
    }

    @Test
    public void testHide() {
        this.tested.hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(UserAssignedRolesEditor.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testShow() {
        this.tested.show(this.user);
        Assert.assertFalse((boolean)this.tested.isEditMode);
        Assert.assertTrue((this.tested.entities.size() == 1 ? 1 : 0) != 0);
        ((RolesExplorer)Mockito.verify((Object)this.rolesExplorer, (VerificationMode)Mockito.times((int)1))).show((ExplorerViewContext)ArgumentMatchers.any(ExplorerViewContext.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(UserAssignedRolesEditor.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testEdit() {
        this.tested.edit(this.user);
        Assert.assertTrue((boolean)this.tested.isEditMode);
        Assert.assertTrue((this.tested.entities.size() == 1 ? 1 : 0) != 0);
        ((RolesExplorer)Mockito.verify((Object)this.rolesExplorer, (VerificationMode)Mockito.times((int)1))).show((ExplorerViewContext)ArgumentMatchers.any(ExplorerViewContext.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(UserAssignedRolesEditor.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testCloseEditorCallback() {
        this.tested.closeEditorCallback.execute();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(UserAssignedRolesEditor.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testSaveEditorCallback() {
        HashSet<String> selectedRoles = new HashSet<String>();
        selectedRoles.add("roleE1");
        Mockito.when((Object)this.rolesExplorer.getSelectedEntities()).thenReturn(selectedRoles);
        this.tested.saveEditorCallback.execute();
        Assert.assertTrue((this.tested.entities.size() == 1 ? 1 : 0) != 0);
        ((RolesExplorer)Mockito.verify((Object)this.rolesExplorer, (VerificationMode)Mockito.times((int)1))).getSelectedEntities();
        ((RolesExplorer)Mockito.verify((Object)this.rolesExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        ((EventSourceMock)Mockito.verify(this.updateUserRolesEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(OnUpdateUserRolesEvent.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(UserAssignedRolesEditor.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    private void assertNoViewCalls() {
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(UserAssignedRolesEditor.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }
}

