/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl.node;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.BasePermissionNodeViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.HasResources;
import org.uberfire.security.client.authz.tree.PermissionNode;

@Dependent
public class MultiplePermissionNodeViewer
extends BasePermissionNodeViewer {
    View view;
    PermissionWidgetFactory widgetFactory;
    PermissionNode permissionNode;
    List<PermissionNode> overwriteList = new ArrayList<PermissionNode>();
    List<PermissionNodeViewer> childViewerList = new ArrayList<PermissionNodeViewer>();

    @Inject
    public MultiplePermissionNodeViewer(View view, PermissionWidgetFactory widgetFactory) {
        this.view = view;
        this.widgetFactory = widgetFactory;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public boolean hasResources() {
        return this.permissionNode instanceof HasResources;
    }

    @Override
    public PermissionNode getPermissionNode() {
        return this.permissionNode;
    }

    @Override
    public List<PermissionNodeViewer> getChildren() {
        return this.childViewerList;
    }

    @Override
    public void show(PermissionNode node) {
        this.permissionNode = node;
        this.overwriteList.clear();
        this.childViewerList.clear();
        String name = node.getNodeName();
        String fullName = node.getNodeFullName();
        this.view.setNodeName(name);
        if (fullName != null && !fullName.equals(name)) {
            this.view.setNodeFullName(fullName);
        }
        this.permissionNode.expand(children -> {
            this.initChildren(children);
            this.showPermissions();
        });
    }

    protected void initChildren(List<PermissionNode> children) {
        for (PermissionNode child : children) {
            List implied = this.permissionNode.impliesName(child);
            if (this.hasResources() && !implied.isEmpty()) {
                this.overwriteList.add(child);
                continue;
            }
            this.registerChild(child);
        }
    }

    protected void registerChild(PermissionNode child) {
        PermissionNodeViewer nodeViewer = this.widgetFactory.createViewer(child);
        nodeViewer.setTreeLevel(this.getTreeLevel() + 1);
        this.childViewerList.add(nodeViewer);
        this.view.addChildViewer(nodeViewer);
        nodeViewer.show(child);
    }

    protected List<PermissionNode> getOverwrites(Permission parent) {
        ArrayList<PermissionNode> result = new ArrayList<PermissionNode>();
        for (PermissionNode node : this.overwriteList) {
            for (Permission p : node.getPermissionList()) {
                if (!parent.impliesName(p) || parent.impliesResult(p)) continue;
                result.add(node);
            }
        }
        return result;
    }

    protected void showPermissions() {
        List permissionList = this.permissionNode.getPermissionList();
        boolean permissionsEnabled = this.hasResources() && !permissionList.isEmpty();
        this.view.setPermissionsVisible(permissionsEnabled);
        if (permissionsEnabled) {
            for (Permission permission : permissionList) {
                String resourceName = this.permissionNode.getNodeName().toLowerCase();
                String permissionGrantName = this.permissionNode.getPermissionGrantName(permission).toLowerCase();
                List<PermissionNode> overwrites = this.getOverwrites(permission);
                if (overwrites.isEmpty()) {
                    if (AuthorizationResult.ACCESS_GRANTED.equals((Object)permission.getResult())) {
                        this.view.addAllItemsGrantedPermission(permissionGrantName, resourceName);
                        continue;
                    }
                    this.view.addAllItemsDeniedPermission(permissionGrantName, resourceName);
                    continue;
                }
                if (AuthorizationResult.ACCESS_GRANTED.equals((Object)permission.getResult())) {
                    this.view.addItemsGrantedPermission(permissionGrantName, resourceName);
                } else {
                    this.view.addItemsDeniedPermission(permissionGrantName, resourceName);
                }
                for (PermissionNode overwrite : overwrites) {
                    String itemName = overwrite.getNodeName();
                    this.view.addItemException(itemName);
                }
            }
        }
    }

    public static interface View
    extends UberView<MultiplePermissionNodeViewer> {
        public void setNodeName(String var1);

        public void setNodeFullName(String var1);

        public void addChildViewer(PermissionNodeViewer var1);

        public void setPermissionsVisible(boolean var1);

        public void addAllItemsGrantedPermission(String var1, String var2);

        public void addAllItemsDeniedPermission(String var1, String var2);

        public void addItemsGrantedPermission(String var1, String var2);

        public void addItemsDeniedPermission(String var1, String var2);

        public void addItemException(String var1);
    }
}

