/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.role.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.Role;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.authz.AuthorizationService;
import org.uberfire.client.authz.PerspectiveAction;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.security.management.client.editor.role.RoleEditorDriver;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLSettings;
import org.uberfire.ext.security.management.client.widgets.management.editor.role.RoleEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.role.workflow.RoleEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveRoleEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionCollection;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class RoleEditorWorkflowTest
extends AbstractSecurityManagementTest {
    @Mock
    Caller<AuthorizationService> authorizationService;
    @Mock
    EventSourceMock<OnErrorEvent> errorEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    LoadingBox loadingBox;
    @Mock
    EventSourceMock<SaveRoleEvent> saveRoleEvent;
    @Mock
    RoleEditor roleEditor;
    @Mock
    RoleEditorDriver roleEditorDriver;
    @Mock
    EntityWorkflowView view;
    @Mock
    ACLSettings aclSettings;
    @Mock
    PerspectiveActivity homePerspective;
    @Mock
    Role role;
    PermissionManager permissionManager;
    PermissionCollection permissionCollection;
    RoleEditorWorkflow tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.permissionCollection = new DefaultPermissionCollection();
        this.permissionManager = new DefaultPermissionManager();
        Mockito.when((Object)this.homePerspective.getIdentifier()).thenReturn((Object)"home");
        Mockito.when((Object)this.homePerspective.getResourceType()).thenReturn((Object)ActivityResourceType.PERSPECTIVE);
        Mockito.when((Object)this.roleEditor.permissions()).thenReturn((Object)this.permissionCollection);
        Mockito.when((Object)this.aclSettings.getHomePerspective()).thenReturn((Object)this.homePerspective);
        Mockito.when((Object)this.roleEditor.getAclSettings()).thenReturn((Object)this.aclSettings);
        Mockito.when((Object)this.role.getName()).thenReturn((Object)"role1");
        Mockito.when((Object)this.view.setWidget((IsWidget)ArgumentMatchers.any())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.clearNotifications()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCancelButtonVisible(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonEnabled(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonVisible(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonText((String)ArgumentMatchers.any())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.showNotification((String)ArgumentMatchers.any())).thenReturn((Object)this.view);
        Mockito.when((Object)((Role)this.rolesManagerService.get((String)ArgumentMatchers.any()))).thenReturn((Object)this.role);
        this.tested = (RoleEditorWorkflow)Mockito.spy((Object)new RoleEditorWorkflow(this.userSystemManager, this.authorizationService, this.permissionManager, this.errorEvent, (Event)this.workbenchNotification, this.saveRoleEvent, this.confirmBox, this.roleEditor, this.roleEditorDriver, this.loadingBox, this.view));
    }

    @Test
    public void testClear() {
        this.tested.role = this.role;
        this.tested.clear();
        Assert.assertNull((Object)this.tested.role);
        ((RoleEditor)Mockito.verify((Object)this.roleEditor)).clear();
        ((RoleEditor)Mockito.verify((Object)this.roleEditor, (VerificationMode)Mockito.never())).show((Role)ArgumentMatchers.any(Role.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).clearNotifications();
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCancelButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setWidget((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSaveButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSaveButtonEnabled(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showNotification(ArgumentMatchers.anyString());
    }

    @Test
    public void testShow() {
        String name = "role1";
        this.tested.show("role1");
        ((EntityWorkflowView)Mockito.verify((Object)this.view)).setCancelButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view)).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view)).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view)).setWidget((IsWidget)ArgumentMatchers.any());
        ((EntityWorkflowView)Mockito.verify((Object)this.view)).setSaveButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view)).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showNotification(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view)).clearNotifications();
        ((RoleEditorDriver)Mockito.verify((Object)this.roleEditorDriver)).edit(this.role, (org.uberfire.ext.security.management.client.editor.role.RoleEditor)this.roleEditor);
        ((RoleEditor)Mockito.verify((Object)this.roleEditor)).clear();
    }

    @Test
    public void testShowError() {
        Throwable error = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)error.getMessage()).thenReturn((Object)"error1");
        this.tested.showError(error);
        ((EventSourceMock)Mockito.verify(this.errorEvent)).fire((Object)((OnErrorEvent)ArgumentMatchers.any(OnErrorEvent.class)));
    }

    @Test
    public void testHomePerspectiveGranted() {
        this.permissionCollection.add(new Permission[]{this.permissionManager.createPermission((Resource)this.homePerspective, PerspectiveAction.READ, true)});
        this.tested.edit();
        ((RoleEditorWorkflow)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.never())).showNotification(ArgumentMatchers.anyString());
    }

    @Test
    public void testHomePerspectiveDenied() {
        this.permissionCollection.add(new Permission[]{this.permissionManager.createPermission((Resource)this.homePerspective, PerspectiveAction.READ, false)});
        this.tested.edit();
        ((RoleEditorWorkflow)Mockito.verify((Object)this.tested)).showNotification(ArgumentMatchers.anyString());
    }
}

