/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gwtbootstrap3.client.ui.constants.LabelType;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.events.AddUsersToGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.NewGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.explorer.ExplorerViewContext;
import org.uberfire.ext.security.management.client.widgets.management.explorer.GroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class GroupsExplorerTest
extends AbstractSecurityManagementTest {
    @Mock
    EntitiesExplorerView view;
    @Mock
    EventSourceMock<OnErrorEvent> onErrorEvent;
    @Mock
    LoadingBox loadingBox;
    @Mock
    EntitiesList<Group> entitiesList;
    @Mock
    EventSourceMock<ReadGroupEvent> readGroupEvent;
    @Mock
    EventSourceMock<NewGroupEvent> newGroupEvent;
    private GroupsExplorer presenter;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.presenter = new GroupsExplorer(this.userSystemManager, this.onErrorEvent, this.loadingBox, this.entitiesList, this.view, this.readGroupEvent, this.newGroupEvent);
        junit.framework.Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testClear() throws Exception {
        this.presenter.clear();
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearSearch();
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showMessage((LabelType)Mockito.any(LabelType.class), Mockito.anyString());
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show((EntitiesExplorerView.ViewContext)Mockito.any(EntitiesExplorerView.ViewContext.class), (EntitiesExplorerView.ViewCallback)Mockito.any(EntitiesExplorerView.ViewCallback.class));
        Assert.assertNull((Object)this.presenter.context);
        Assert.assertNull((Object)this.presenter.selected);
        Assert.assertEquals((long)this.presenter.currentPage, (long)1L);
    }

    @Test
    public void testLoadingViewShow() throws Exception {
        this.presenter.showLoadingView();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void testLoadingViewHide() throws Exception {
        this.presenter.hideLoadingView();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void testShowError() throws Exception {
        String message = "error1";
        Throwable t = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)t.getMessage()).thenReturn((Object)"error1");
        this.presenter.showError(t);
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((EventSourceMock)Mockito.verify(this.onErrorEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((OnErrorEvent)Mockito.any(OnErrorEvent.class)));
    }

    @Test
    public void testShowNotAllowed() throws Exception {
        Mockito.when((Object)this.userSystemManager.isGroupCapabilityEnabled(Capability.CAN_SEARCH_GROUPS)).thenReturn((Object)false);
        ExplorerViewContext context = (ExplorerViewContext)Mockito.mock(ExplorerViewContext.class);
        this.presenter.show(context);
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showMessage((LabelType)Mockito.any(LabelType.class), Mockito.anyString());
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show((EntitiesExplorerView.ViewContext)Mockito.any(EntitiesExplorerView.ViewContext.class), (EntitiesExplorerView.ViewCallback)Mockito.any(EntitiesExplorerView.ViewCallback.class));
    }

    @Test
    public void testShow() throws Exception {
        ExplorerViewContext context = this.createContext(true, true, true, true, true, new HashSet<String>());
        List<Group> groups = this.buildGroupsList(10);
        AbstractEntityManager.SearchResponse<Group> response = this.createResponse(groups, 10, false);
        this.testShow(context, response);
    }

    @Test
    public void testShowConstrained() throws Exception {
        ExplorerViewContext context = this.createContext(true, true, true, true, true, new HashSet<String>());
        context.getConstrainedEntities().add("group8");
        context.getConstrainedEntities().add("group9");
        List<Group> groups = this.buildGroupsList(8);
        AbstractEntityManager.SearchResponse<Group> response = this.createResponse(groups, 8, false);
        this.testShow(context, response);
    }

    @Test
    public void testShowWithSelectedGroups() throws Exception {
        HashSet<String> selectedGroups = new HashSet<String>(5);
        selectedGroups.add("group0");
        selectedGroups.add("group1");
        selectedGroups.add("group2");
        selectedGroups.add("group3");
        selectedGroups.add("group4");
        ExplorerViewContext context = this.createContext(true, true, true, true, true, selectedGroups);
        List<Group> groups = this.buildGroupsList(10);
        AbstractEntityManager.SearchResponse<Group> response = this.createResponse(groups, 10, false);
        this.testShow(context, response);
    }

    @Test
    public void testOnDeleteGroup() throws Exception {
        DeleteGroupEvent deleteGroupEvent = (DeleteGroupEvent)Mockito.mock(DeleteGroupEvent.class);
        this.presenter.context = (ExplorerViewContext)Mockito.mock(ExplorerViewContext.class);
        this.presenter.onGroupDeleted(deleteGroupEvent);
        ((GroupManagerService)Mockito.verify((Object)this.groupsManagerService, (VerificationMode)Mockito.times((int)1))).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    @Test
    public void testOnDeleteGroupButNoContext() throws Exception {
        DeleteGroupEvent deleteGroupEvent = (DeleteGroupEvent)Mockito.mock(DeleteGroupEvent.class);
        this.presenter.context = null;
        this.presenter.onGroupDeleted(deleteGroupEvent);
        ((GroupManagerService)Mockito.verify((Object)this.groupsManagerService, (VerificationMode)Mockito.never())).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    @Test
    public void testOnCreateGroup() throws Exception {
        CreateGroupEvent createGroupEvent = (CreateGroupEvent)Mockito.mock(CreateGroupEvent.class);
        this.presenter.context = (ExplorerViewContext)Mockito.mock(ExplorerViewContext.class);
        this.presenter.onGroupCreated(createGroupEvent);
        ((GroupManagerService)Mockito.verify((Object)this.groupsManagerService, (VerificationMode)Mockito.times((int)1))).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    @Test
    public void testOnCreateGroupButNoContext() throws Exception {
        CreateGroupEvent createGroupEvent = (CreateGroupEvent)Mockito.mock(CreateGroupEvent.class);
        this.presenter.context = null;
        this.presenter.onGroupCreated(createGroupEvent);
        ((GroupManagerService)Mockito.verify((Object)this.groupsManagerService, (VerificationMode)Mockito.never())).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    @Test
    public void testOnAddUsersToGroupEvent() throws Exception {
        AddUsersToGroupEvent addUsersToGroupEvent = (AddUsersToGroupEvent)Mockito.mock(AddUsersToGroupEvent.class);
        this.presenter.context = (ExplorerViewContext)Mockito.mock(ExplorerViewContext.class);
        this.presenter.onAddUsersToGroup(addUsersToGroupEvent);
        ((GroupManagerService)Mockito.verify((Object)this.groupsManagerService, (VerificationMode)Mockito.times((int)1))).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    @Test
    public void testOnAddUsersToGroupEventButNoContext() throws Exception {
        AddUsersToGroupEvent addUsersToGroupEvent = (AddUsersToGroupEvent)Mockito.mock(AddUsersToGroupEvent.class);
        this.presenter.context = null;
        this.presenter.onAddUsersToGroup(addUsersToGroupEvent);
        ((GroupManagerService)Mockito.verify((Object)this.groupsManagerService, (VerificationMode)Mockito.never())).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    private ExplorerViewContext createContext(boolean canCreate, boolean canRead, boolean canDelete, boolean canSearch, boolean canSelect, Set<String> selectedGroups) {
        ExplorerViewContext context = (ExplorerViewContext)Mockito.mock(ExplorerViewContext.class);
        Mockito.when((Object)context.canCreate()).thenReturn((Object)canCreate);
        Mockito.when((Object)context.canRead()).thenReturn((Object)canRead);
        Mockito.when((Object)context.canDelete()).thenReturn((Object)canDelete);
        Mockito.when((Object)context.canSearch()).thenReturn((Object)canSearch);
        Mockito.when((Object)context.canSelect()).thenReturn((Object)canSelect);
        Mockito.when((Object)context.getSelectedEntities()).thenReturn(selectedGroups);
        return context;
    }

    private AbstractEntityManager.SearchResponse<Group> createResponse(List<Group> groups, int size, boolean hasNextPage) {
        AbstractEntityManager.SearchResponse response = (AbstractEntityManager.SearchResponse)Mockito.mock(AbstractEntityManager.SearchResponse.class);
        Mockito.when((Object)response.getResults()).thenReturn(groups);
        Mockito.when((Object)response.getTotal()).thenReturn((Object)size);
        Mockito.when((Object)response.hasNextPage()).thenReturn((Object)hasNextPage);
        return response;
    }

    private void testShow(ExplorerViewContext context, final AbstractEntityManager.SearchResponse<Group> response) {
        Mockito.when((Object)this.groupsManagerService.search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class))).thenAnswer((Answer)new Answer<AbstractEntityManager.SearchResponse<Group>>(){

            public AbstractEntityManager.SearchResponse<Group> answer(InvocationOnMock invocationOnMock) throws Throwable {
                return response;
            }
        });
        this.presenter.show(context);
        junit.framework.Assert.assertEquals((Object)context, (Object)this.presenter.context);
        junit.framework.Assert.assertEquals((Object)context.getSelectedEntities(), (Object)this.presenter.selected);
        ((ExplorerViewContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).setParent((EntitiesExplorerView.ViewContext)Mockito.any(EntitiesExplorerView.ViewContext.class));
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showMessage((LabelType)Mockito.any(LabelType.class), Mockito.anyString());
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ArgumentCaptor responseArgumentCaptor = ArgumentCaptor.forClass(AbstractEntityManager.SearchResponse.class);
        ArgumentCaptor callbackArgumentCaptor = ArgumentCaptor.forClass(EntitiesList.Callback.class);
        ((EntitiesList)Mockito.verify(this.entitiesList, (VerificationMode)Mockito.times((int)1))).show((AbstractEntityManager.SearchResponse)responseArgumentCaptor.capture(), (EntitiesList.Callback)callbackArgumentCaptor.capture());
        AbstractEntityManager.SearchResponse responseArgumentCaptured = (AbstractEntityManager.SearchResponse)responseArgumentCaptor.getValue();
        List results = response.getResults();
        junit.framework.Assert.assertEquals((Object)results, (Object)responseArgumentCaptured.getResults());
        junit.framework.Assert.assertEquals((int)response.getTotal(), (int)responseArgumentCaptured.getTotal());
        junit.framework.Assert.assertEquals((boolean)response.hasNextPage(), (boolean)responseArgumentCaptured.hasNextPage());
        EntitiesList.Callback callbackArgumentCaptured = (EntitiesList.Callback)callbackArgumentCaptor.getValue();
        junit.framework.Assert.assertEquals((boolean)context.canRead(), (boolean)callbackArgumentCaptured.canRead());
        junit.framework.Assert.assertEquals((boolean)context.canDelete(), (boolean)callbackArgumentCaptured.canRemove());
        junit.framework.Assert.assertEquals((boolean)context.canSelect(), (boolean)callbackArgumentCaptured.canSelect());
        int x = 0;
        for (Group _group : results) {
            String gname = this.getGroupIdentifier(x);
            junit.framework.Assert.assertEquals((String)gname, (String)callbackArgumentCaptured.getIdentifier((Object)_group));
            junit.framework.Assert.assertEquals((String)gname, (String)callbackArgumentCaptured.getTitle((Object)_group));
            boolean isSelected = context.getSelectedEntities() != null && context.getSelectedEntities().contains(gname);
            junit.framework.Assert.assertEquals((boolean)isSelected, (boolean)callbackArgumentCaptured.isSelected(_group.getName()));
            ++x;
        }
    }
}

