/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLSettings;

@Dependent
@Templated
public class ACLSettingsView
extends Composite
implements ACLSettings.View {
    @DataField
    LabelElement homePerspectiveLabel = Document.get().createLabelElement();
    @Inject
    @DataField
    Span homePerspectiveName;
    @Inject
    @DataField
    FlowPanel homePerspectiveSelectorPanel;
    @Inject
    @DataField
    Span homePerspectiveHelp;
    @DataField
    LabelElement priorityLabel = Document.get().createLabelElement();
    @Inject
    @DataField
    Span priorityValue;
    @Inject
    @DataField
    FlowPanel prioritySelectorPanel;
    @Inject
    @DataField
    Span priorityHelp;
    private ACLSettings presenter;

    public void init(ACLSettings presenter) {
        this.presenter = presenter;
        this.homePerspectiveLabel.setInnerText(UsersManagementWidgetsConstants.INSTANCE.homePerspective());
        this.homePerspectiveHelp.setAttribute("title", UsersManagementWidgetsConstants.INSTANCE.homePerspectiveTooltip());
        this.priorityLabel.setInnerText(UsersManagementWidgetsConstants.INSTANCE.priority());
        this.priorityHelp.setAttribute("title", UsersManagementWidgetsConstants.INSTANCE.priorityTooltip());
    }

    @Override
    public ACLSettings.View setHomePerspectiveName(String name) {
        this.homePerspectiveName.setTextContent("\"" + name + "\"");
        return this;
    }

    @Override
    public ACLSettings.View setHomePerspectiveTitle(String name) {
        this.homePerspectiveName.setTitle(name);
        return this;
    }

    @Override
    public ACLSettings.View setNoHomePerspectiveDefined() {
        String undefined = UsersManagementWidgetsConstants.INSTANCE.noHomePerspective();
        this.homePerspectiveName.setTextContent(undefined);
        return this;
    }

    @Override
    public ACLSettings.View setHomePerspectiveSelector(IsWidget widget) {
        this.homePerspectiveSelectorPanel.clear();
        this.homePerspectiveSelectorPanel.add(widget);
        return this;
    }

    @Override
    public ACLSettings.View setHomePerspectiveSelectorEnabled(boolean enabled) {
        this.homePerspectiveSelectorPanel.setVisible(enabled);
        if (enabled) {
            this.homePerspectiveName.getStyle().setProperty("display", "none");
        } else {
            this.homePerspectiveName.getStyle().removeProperty("display");
        }
        return this;
    }

    @Override
    public ACLSettings.View setPriorityName(String name) {
        this.priorityValue.setTextContent("\"" + name + "\"");
        return this;
    }

    @Override
    public ACLSettings.View setPrioritySelector(IsWidget widget) {
        this.prioritySelectorPanel.clear();
        this.prioritySelectorPanel.add(widget);
        return this;
    }

    @Override
    public ACLSettings.View setPrioritySelectorEnabled(boolean enabled) {
        this.prioritySelectorPanel.setVisible(enabled);
        if (enabled) {
            this.priorityValue.getStyle().setProperty("display", "none");
        } else {
            this.priorityValue.getStyle().removeProperty("display");
        }
        return this;
    }
}

