/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import java.util.HashMap;
import java.util.HashSet;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAttributesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.widgets.management.events.OnChangePasswordEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnShowEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserGroupsEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserRolesEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class UserEditorTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    @Mock
    UserAttributesEditor userAttributesEditor;
    @Mock
    UserAssignedGroupsExplorer userAssignedGroupsExplorer;
    @Mock
    UserAssignedRolesExplorer userAssignedRolesExplorer;
    @Mock
    UserAssignedGroupsEditor userAssignedGroupsEditor;
    @Mock
    UserAssignedRolesEditor userAssignedRolesEditor;
    @Mock
    ACLViewer aclViewer;
    @Mock
    EventSourceMock<OnEditEvent> onEditEvent;
    @Mock
    EventSourceMock<OnShowEvent> onShowEvent;
    @Mock
    EventSourceMock<OnDeleteEvent> onDeleteEvent;
    @Mock
    EventSourceMock<OnChangePasswordEvent> onChangePasswordEvent;
    @Mock
    UserEditor.View view;
    @Mock
    User user;
    private UserEditor presenter;

    @Before
    public void setup() {
        HashMap<String, String> userAttributes = new HashMap<String, String>(1);
        userAttributes.put("attr1", "value1");
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.user.getProperties()).thenReturn(userAttributes);
        Mockito.when((Object)this.userSystemManager.isUserCapabilityEnabled((Capability)ArgumentMatchers.any(Capability.class))).thenReturn((Object)true);
        this.presenter = new UserEditor(this.userSystemManager, this.userAttributesEditor, this.userAssignedGroupsExplorer, this.userAssignedGroupsEditor, this.userAssignedRolesExplorer, this.userAssignedRolesEditor, this.aclViewer, this.onEditEvent, this.onShowEvent, this.onDeleteEvent, this.onChangePasswordEvent, this.view);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((UserAttributesEditor.View)ArgumentMatchers.any(), (AssignedEntitiesExplorer)ArgumentMatchers.any(), (AssignedEntitiesEditor)ArgumentMatchers.any(), (AssignedEntitiesExplorer)ArgumentMatchers.any(), (AssignedEntitiesEditor)ArgumentMatchers.any(), (ACLViewer)ArgumentMatchers.any());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddToGroupsButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAttributesEditorVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setChangePasswordButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDeleteButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEditButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setUsername(ArgumentMatchers.anyString());
    }

    @Test
    public void testClear() {
        this.presenter.isEditMode = true;
        this.presenter.user = this.user;
        this.presenter.clear();
        Assert.assertNull((Object)this.presenter.user);
        Assert.assertFalse((boolean)this.presenter.isEditMode);
        ((UserAttributesEditor)Mockito.verify((Object)this.userAttributesEditor, (VerificationMode)Mockito.times((int)1))).clear();
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)this.userAssignedGroupsExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        ((UserAssignedGroupsEditor)Mockito.verify((Object)this.userAssignedGroupsEditor, (VerificationMode)Mockito.times((int)1))).clear();
        this.assertNoViewCalls();
    }

    @Test
    public void testIdentifier() {
        this.presenter.user = this.user;
        String id = this.presenter.identifier();
        Assert.assertEquals((Object)"user1", (Object)id);
        this.assertNoViewCalls();
    }

    @Test
    public void testAttributesEditor() {
        Assert.assertEquals((Object)this.userAttributesEditor, (Object)this.presenter.attributesEditor());
        this.assertNoViewCalls();
    }

    @Test
    public void testGroupsExplorer() {
        Assert.assertEquals((Object)this.userAssignedGroupsExplorer, (Object)this.presenter.groupsExplorer());
        this.assertNoViewCalls();
    }

    @Test
    public void testGroupsEditor() {
        Assert.assertEquals((Object)this.userAssignedGroupsEditor, (Object)this.presenter.groupsEditor());
        this.assertNoViewCalls();
    }

    @Test
    public void testRolesExplorer() {
        Assert.assertEquals((Object)this.userAssignedRolesExplorer, (Object)this.presenter.rolesExplorer());
        this.assertNoViewCalls();
    }

    @Test
    public void testRolesEditor() {
        Assert.assertEquals((Object)this.userAssignedRolesEditor, (Object)this.presenter.rolesEditor());
        this.assertNoViewCalls();
    }

    @Test
    public void testShow() {
        this.presenter.show(this.user);
        Assert.assertFalse((boolean)this.presenter.isEditMode);
        ((UserAttributesEditor)Mockito.verify((Object)this.userAttributesEditor, (VerificationMode)Mockito.times((int)1))).clear();
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)this.userAssignedGroupsExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        ((UserAssignedRolesExplorer)Mockito.verify((Object)this.userAssignedRolesExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        ((UserAssignedGroupsEditor)Mockito.verify((Object)this.userAssignedGroupsEditor, (VerificationMode)Mockito.times((int)1))).clear();
        ((EventSourceMock)Mockito.verify(this.onShowEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((OnShowEvent)ArgumentMatchers.any(OnShowEvent.class)));
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((UserEditor)ArgumentMatchers.any(UserEditor.class)));
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((UserAttributesEditor.View)ArgumentMatchers.any(UserAttributesEditor.View.class), (AssignedEntitiesExplorer)ArgumentMatchers.any(AssignedEntitiesExplorer.class), (AssignedEntitiesEditor)ArgumentMatchers.any(AssignedEntitiesEditor.class), (AssignedEntitiesExplorer)ArgumentMatchers.any(AssignedEntitiesExplorer.class), (AssignedEntitiesEditor)ArgumentMatchers.any(AssignedEntitiesEditor.class), (ACLViewer)ArgumentMatchers.any(ACLViewer.class));
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setAddToGroupsButtonVisible(false);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setAttributesEditorVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setChangePasswordButtonVisible(false);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDeleteButtonVisible(false);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEditButtonVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setUsername("user1");
    }

    @Test
    public void testSetEditButtonVisible() {
        this.presenter.setEditButtonVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEditButtonVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddToGroupsButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAttributesEditorVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setChangePasswordButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDeleteButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setUsername(ArgumentMatchers.anyString());
    }

    @Test
    public void testSetDeleteButtonVisible() {
        this.presenter.setDeleteButtonVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDeleteButtonVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddToGroupsButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAttributesEditorVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setChangePasswordButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEditButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setUsername(ArgumentMatchers.anyString());
    }

    @Test
    public void testSetChangePasswordButtonVisible() {
        this.presenter.setChangePasswordButtonVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setChangePasswordButtonVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddToGroupsButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAttributesEditorVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDeleteButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEditButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setUsername(ArgumentMatchers.anyString());
    }

    @Test
    public void testSetAttributesEditorVisible() {
        this.presenter.setAttributesEditorVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setAttributesEditorVisible(true);
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddToGroupsButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setChangePasswordButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDeleteButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEditButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setUsername(ArgumentMatchers.anyString());
    }

    @Test
    public void testOnEdit() {
        this.presenter.onEdit();
        ((EventSourceMock)Mockito.verify(this.onEditEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((OnEditEvent)ArgumentMatchers.any(OnEditEvent.class)));
        this.assertNoViewCalls();
    }

    @Test
    public void testOnDelete() {
        this.presenter.onDelete();
        ((EventSourceMock)Mockito.verify(this.onDeleteEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((OnDeleteEvent)ArgumentMatchers.any(OnDeleteEvent.class)));
        this.assertNoViewCalls();
    }

    @Test
    public void testOnChangePassword() {
        this.presenter.onChangePassword();
        ((EventSourceMock)Mockito.verify(this.onChangePasswordEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((OnChangePasswordEvent)ArgumentMatchers.any(OnChangePasswordEvent.class)));
        this.assertNoViewCalls();
    }

    @Test
    public void testOnAssignGroupsInReadMode() {
        this.presenter.user = this.user;
        this.presenter.isEditMode = false;
        this.presenter.onAssignGroups();
        ((UserAssignedGroupsEditor)Mockito.verify((Object)this.userAssignedGroupsEditor, (VerificationMode)Mockito.times((int)1))).show((User)ArgumentMatchers.any(User.class));
        ((UserAssignedGroupsEditor)Mockito.verify((Object)this.userAssignedGroupsEditor, (VerificationMode)Mockito.times((int)0))).edit((User)ArgumentMatchers.any(User.class));
        this.assertNoViewCalls();
    }

    @Test
    public void testOnAssignGroupsInEditMode() {
        this.presenter.user = this.user;
        this.presenter.isEditMode = true;
        this.presenter.onAssignGroups();
        ((UserAssignedGroupsEditor)Mockito.verify((Object)this.userAssignedGroupsEditor, (VerificationMode)Mockito.times((int)0))).show((User)ArgumentMatchers.any(User.class));
        ((UserAssignedGroupsEditor)Mockito.verify((Object)this.userAssignedGroupsEditor, (VerificationMode)Mockito.times((int)1))).edit((User)ArgumentMatchers.any(User.class));
        this.assertNoViewCalls();
    }

    @Test
    public void testOnOnUserGroupsUpdatedEvent() {
        OnUpdateUserGroupsEvent onUpdateUserGroupsEvent = (OnUpdateUserGroupsEvent)Mockito.mock(OnUpdateUserGroupsEvent.class);
        Mockito.when((Object)onUpdateUserGroupsEvent.getContext()).thenReturn((Object)this.userAssignedGroupsEditor);
        HashSet explorerGroups = new HashSet();
        Mockito.when((Object)this.userAssignedGroupsExplorer.getValue()).thenReturn(explorerGroups);
        HashSet<GroupImpl> groups = new HashSet<GroupImpl>();
        groups.add(new GroupImpl("group1"));
        Mockito.when((Object)this.userAssignedGroupsEditor.getValue()).thenReturn(groups);
        this.presenter.onOnUserGroupsUpdatedEvent(onUpdateUserGroupsEvent);
        Assert.assertEquals(groups, (Object)this.userAssignedGroupsExplorer.getValue());
        ((UserAssignedGroupsEditor)Mockito.verify((Object)this.userAssignedGroupsEditor, (VerificationMode)Mockito.times((int)1))).flush();
        ((UserAssignedGroupsExplorer)Mockito.verify((Object)this.userAssignedGroupsExplorer, (VerificationMode)Mockito.times((int)1))).doShow();
        this.assertNoViewCalls();
    }

    @Test
    public void testOnAssignRolesInReadMode() {
        this.presenter.user = this.user;
        this.presenter.isEditMode = false;
        this.presenter.onAssignRoles();
        ((UserAssignedRolesEditor)Mockito.verify((Object)this.userAssignedRolesEditor, (VerificationMode)Mockito.times((int)1))).show((User)ArgumentMatchers.any(User.class));
        ((UserAssignedRolesEditor)Mockito.verify((Object)this.userAssignedRolesEditor, (VerificationMode)Mockito.times((int)0))).edit((User)ArgumentMatchers.any(User.class));
        this.assertNoViewCalls();
    }

    @Test
    public void testOnAssignRolesInEditMode() {
        this.presenter.user = this.user;
        this.presenter.isEditMode = true;
        this.presenter.onAssignRoles();
        ((UserAssignedRolesEditor)Mockito.verify((Object)this.userAssignedRolesEditor, (VerificationMode)Mockito.times((int)0))).show((User)ArgumentMatchers.any(User.class));
        ((UserAssignedRolesEditor)Mockito.verify((Object)this.userAssignedRolesEditor, (VerificationMode)Mockito.times((int)1))).edit((User)ArgumentMatchers.any(User.class));
        this.assertNoViewCalls();
    }

    @Test
    public void testOnOnUserRolesUpdatedEvent() {
        OnUpdateUserRolesEvent onUpdateUserRolesEvent = (OnUpdateUserRolesEvent)Mockito.mock(OnUpdateUserRolesEvent.class);
        Mockito.when((Object)onUpdateUserRolesEvent.getContext()).thenReturn((Object)this.userAssignedRolesEditor);
        HashSet explorerRoles = new HashSet();
        Mockito.when((Object)this.userAssignedRolesExplorer.getValue()).thenReturn(explorerRoles);
        HashSet<RoleImpl> roles = new HashSet<RoleImpl>();
        roles.add(new RoleImpl("role1"));
        Mockito.when((Object)this.userAssignedRolesEditor.getValue()).thenReturn(roles);
        this.presenter.onOnUserRolesUpdatedEvent(onUpdateUserRolesEvent);
        Assert.assertEquals(roles, (Object)this.userAssignedRolesExplorer.getValue());
        ((UserAssignedRolesEditor)Mockito.verify((Object)this.userAssignedRolesEditor, (VerificationMode)Mockito.times((int)1))).flush();
        ((UserAssignedRolesExplorer)Mockito.verify((Object)this.userAssignedRolesExplorer, (VerificationMode)Mockito.times((int)1))).doShow();
        this.assertNoViewCalls();
    }

    private void assertNoViewCalls() {
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((UserEditor)ArgumentMatchers.any(UserEditor.class)));
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((UserAttributesEditor.View)ArgumentMatchers.any(UserAttributesEditor.View.class), (AssignedEntitiesExplorer)ArgumentMatchers.any(AssignedEntitiesExplorer.class), (AssignedEntitiesEditor)ArgumentMatchers.any(AssignedEntitiesEditor.class), (AssignedEntitiesExplorer)ArgumentMatchers.any(AssignedEntitiesExplorer.class), (AssignedEntitiesEditor)ArgumentMatchers.any(AssignedEntitiesEditor.class), (ACLViewer)ArgumentMatchers.any(ACLViewer.class));
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddToGroupsButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAttributesEditorVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setChangePasswordButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDeleteButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEditButtonVisible(ArgumentMatchers.anyBoolean());
        ((UserEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setUsername(ArgumentMatchers.anyString());
    }
}

