/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.LeafPermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.MultiplePermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionExceptionSwitch;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitch;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitchToogle;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeAddedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeRemovedEvent;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchEntry;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.mvp.Command;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionGroupNode;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;
import org.uberfire.security.impl.authz.DotNamedPermission;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiplePermissionNodeEditorTest {
    @Mock
    MultiplePermissionNodeEditor.View view;
    @Mock
    LeafPermissionNodeEditor.View childView1;
    @Mock
    LeafPermissionNodeEditor.View childView2;
    @Mock
    PermissionSwitch.View permissionSwitchReadView;
    @Mock
    PermissionSwitch.View permissionSwitchUpdateView;
    @Mock
    PermissionExceptionSwitch.View permissionSwitchReadView1;
    @Mock
    PermissionExceptionSwitch.View permissionSwitchUpdateView1;
    @Mock
    PermissionExceptionSwitch.View permissionSwitchReadView2;
    @Mock
    PermissionExceptionSwitch.View permissionSwitchUpdateView2;
    @Mock
    LiveSearchDropDown liveSearchDropDown;
    @Mock
    PermissionWidgetFactory widgetFactory;
    @Mock
    PermissionWidgetFactory widgetFactory1;
    @Mock
    PermissionWidgetFactory widgetFactory2;
    @Mock
    Event<PermissionChangedEvent> changedEvent;
    @Mock
    Event<PermissionNodeAddedEvent> nodeAddedEvent;
    @Mock
    Event<PermissionNodeRemovedEvent> nodeRemovedEvent;
    @Mock
    Command onChange;
    PermissionTreeProvider permissionTreeProvider;
    PermissionGroupNode permissionGroupNode;
    PermissionResourceNode permissionResourceNode;
    MultiplePermissionNodeEditor presenter;
    PermissionSwitch permissionSwitchRead;
    PermissionSwitch permissionSwitchUpdate;
    PermissionExceptionSwitch permissionSwitchRead1;
    PermissionExceptionSwitch permissionSwitchUpdate1;
    PermissionExceptionSwitch permissionSwitchRead2;
    PermissionExceptionSwitch permissionSwitchUpdate2;
    PermissionLeafNode permissionChildNode1;
    PermissionLeafNode permissionChildNode2;
    LeafPermissionNodeEditor childEditor1;
    LeafPermissionNodeEditor childEditor2;
    Permission permissionRead;
    Permission permissionUpdate;
    Permission permissionRead1;
    Permission permissionUpdate1;
    Permission permissionRead2;
    Permission permissionUpdate2;
    List<PermissionNode> permissionResourceChildrenAdded = new ArrayList<PermissionNode>();
    List<PermissionNode> permissionResourceChildrenAvailable = new ArrayList<PermissionNode>();

    @Before
    public void setUp() {
        this.permissionTreeProvider = new TestPermissionProvider();
        this.permissionRead = (Permission)Mockito.spy((Object)new DotNamedPermission("read", Boolean.valueOf(true)));
        this.permissionRead1 = (Permission)Mockito.spy((Object)new DotNamedPermission("read.p1", Boolean.valueOf(false)));
        this.permissionRead2 = (Permission)Mockito.spy((Object)new DotNamedPermission("read.p2", Boolean.valueOf(false)));
        this.permissionUpdate = (Permission)Mockito.spy((Object)new DotNamedPermission("update", Boolean.valueOf(true)));
        this.permissionUpdate1 = (Permission)Mockito.spy((Object)new DotNamedPermission("update.p1", Boolean.valueOf(false)));
        this.permissionUpdate2 = (Permission)Mockito.spy((Object)new DotNamedPermission("update.p2", Boolean.valueOf(false)));
        this.permissionSwitchRead = (PermissionSwitch)Mockito.spy((Object)new PermissionSwitch(this.permissionSwitchReadView));
        this.permissionSwitchRead1 = (PermissionExceptionSwitch)Mockito.spy((Object)new PermissionExceptionSwitch(this.permissionSwitchReadView1));
        this.permissionSwitchRead2 = (PermissionExceptionSwitch)Mockito.spy((Object)new PermissionExceptionSwitch(this.permissionSwitchReadView2));
        this.permissionSwitchUpdate = (PermissionSwitch)Mockito.spy((Object)new PermissionSwitch(this.permissionSwitchUpdateView));
        this.permissionSwitchUpdate1 = (PermissionExceptionSwitch)Mockito.spy((Object)new PermissionExceptionSwitch(this.permissionSwitchUpdateView1));
        this.permissionSwitchUpdate2 = (PermissionExceptionSwitch)Mockito.spy((Object)new PermissionExceptionSwitch(this.permissionSwitchUpdateView2));
        this.permissionChildNode1 = (PermissionLeafNode)Mockito.spy((Object)new PermissionLeafNode());
        this.permissionChildNode1.setNodeName("p1");
        this.permissionChildNode1.addPermission(this.permissionRead1, "read", "read");
        this.permissionChildNode1.addPermission(this.permissionUpdate1, "update", "update");
        this.permissionChildNode1.addDependencies(this.permissionRead1, new Permission[]{this.permissionUpdate1});
        this.permissionChildNode2 = (PermissionLeafNode)Mockito.spy((Object)new PermissionLeafNode());
        this.permissionChildNode2.setNodeName("p2");
        this.permissionChildNode2.addPermission(this.permissionRead2, "read", "read");
        this.permissionChildNode2.addPermission(this.permissionUpdate2, "update", "update");
        this.permissionChildNode2.addDependencies(this.permissionRead2, new Permission[]{this.permissionUpdate2});
        this.permissionGroupNode = (PermissionGroupNode)Mockito.spy((Object)new PermissionGroupNode(this.permissionTreeProvider));
        this.permissionGroupNode.setNodeName("group");
        this.permissionGroupNode.addPermission(this.permissionRead, "read", "read");
        this.permissionGroupNode.addPermission(this.permissionUpdate, "update", "update");
        this.permissionGroupNode.addDependencies(this.permissionRead, new Permission[]{this.permissionUpdate});
        this.permissionResourceNode = (PermissionResourceNode)Mockito.spy((Object)new PermissionResourceNode("resource", this.permissionTreeProvider));
        this.permissionResourceNode.setNodeName("resource");
        this.permissionResourceNode.addPermission(this.permissionRead, "read", "read");
        this.permissionResourceNode.addPermission(this.permissionUpdate, "update", "update");
        this.permissionResourceNode.addDependencies(this.permissionRead, new Permission[]{this.permissionUpdate});
        Mockito.when((Object)this.widgetFactory1.createExceptionSwitch()).thenReturn((Object)this.permissionSwitchRead1, (Object[])new PermissionExceptionSwitch[]{this.permissionSwitchUpdate1});
        Mockito.when((Object)this.widgetFactory2.createExceptionSwitch()).thenReturn((Object)this.permissionSwitchRead2, (Object[])new PermissionExceptionSwitch[]{this.permissionSwitchUpdate2});
        this.childEditor1 = (LeafPermissionNodeEditor)Mockito.spy((Object)new LeafPermissionNodeEditor(this.childView1, this.widgetFactory1, this.changedEvent));
        this.childEditor2 = (LeafPermissionNodeEditor)Mockito.spy((Object)new LeafPermissionNodeEditor(this.childView2, this.widgetFactory2, this.changedEvent));
        Mockito.when((Object)this.widgetFactory.createSwitch()).thenReturn((Object)this.permissionSwitchRead, (Object[])new PermissionSwitch[]{this.permissionSwitchUpdate});
        Mockito.when((Object)this.widgetFactory.createEditor((PermissionNode)this.permissionChildNode1)).thenReturn((Object)this.childEditor1);
        Mockito.when((Object)this.widgetFactory.createEditor((PermissionNode)this.permissionChildNode2)).thenReturn((Object)this.childEditor2);
        this.presenter = new MultiplePermissionNodeEditor(this.view, this.liveSearchDropDown, this.widgetFactory, this.changedEvent, this.nodeAddedEvent, this.nodeRemovedEvent);
        this.permissionResourceChildrenAvailable.add((PermissionNode)this.permissionChildNode1);
        this.permissionResourceChildrenAvailable.add((PermissionNode)this.permissionChildNode2);
        this.permissionResourceChildrenAdded.add((PermissionNode)this.permissionChildNode1);
        this.permissionResourceChildrenAdded.add((PermissionNode)this.permissionChildNode2);
        ((PermissionGroupNode)Mockito.doAnswer(invocationOnMock -> {
            LoadCallback callback = (LoadCallback)invocationOnMock.getArguments()[0];
            callback.afterLoad(this.permissionResourceChildrenAdded);
            return null;
        }).when((Object)this.permissionGroupNode)).expand((LoadCallback)Mockito.any(LoadCallback.class));
        ((PermissionResourceNode)Mockito.doAnswer(invocationOnMock -> {
            LoadCallback callback = (LoadCallback)invocationOnMock.getArguments()[0];
            callback.afterLoad(this.permissionResourceChildrenAdded);
            return null;
        }).when((Object)this.permissionResourceNode)).expand((LoadCallback)Mockito.any(LoadCallback.class));
    }

    @Test
    public void testInitGroupNode() {
        this.presenter.edit((PermissionNode)this.permissionGroupNode);
        Assert.assertEquals((long)this.presenter.getChildEditors().size(), (long)2L);
        Assert.assertEquals((Object)this.presenter.getPermissionNode(), (Object)this.permissionGroupNode);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setNodeName("group");
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNodeFullName(Mockito.anyString());
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addPermission((PermissionSwitchToogle)this.permissionSwitchRead);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addPermission((PermissionSwitchToogle)this.permissionSwitchUpdate);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchRead)).init((String)Mockito.eq((Object)"read"), (String)Mockito.eq((Object)"read"), Mockito.eq((boolean)true), Mockito.eq((int)0));
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).init((String)Mockito.eq((Object)"update"), (String)Mockito.eq((Object)"update"), Mockito.eq((boolean)true), Mockito.eq((int)0));
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setClearChildrenEnabled(false);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setAddChildEnabled(true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setChildSelector((IsWidget)Mockito.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.liveSearchDropDown});
    }

    @Test
    public void testInitResourceNode() {
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        Assert.assertEquals((long)this.presenter.getChildEditors().size(), (long)2L);
        Assert.assertEquals((Object)this.presenter.getPermissionNode(), (Object)this.permissionResourceNode);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setAddChildEnabled(true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setChildSelector((IsWidget)this.liveSearchDropDown);
    }

    @Test
    public void testExpandGroupNode() {
        this.presenter.edit((PermissionNode)this.permissionGroupNode);
        this.presenter.onNodeClick();
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addChildEditor((PermissionNodeEditor)this.childEditor1, false);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addChildEditor((PermissionNodeEditor)this.childEditor2, false);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setAddChildEnabled(false);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setAddChildEnabled(true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setChildSelector((IsWidget)Mockito.any());
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setClearChildrenEnabled(true);
        ((LeafPermissionNodeEditor)Mockito.verify((Object)this.childEditor1)).edit((PermissionNode)this.permissionChildNode1);
        ((LeafPermissionNodeEditor)Mockito.verify((Object)this.childEditor2)).edit((PermissionNode)this.permissionChildNode2);
    }

    @Test
    public void testExpandResourceNode() {
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        this.presenter.onNodeClick();
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addChildEditor((PermissionNodeEditor)this.childEditor1, true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).addChildEditor((PermissionNodeEditor)this.childEditor2, true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setAddChildEnabled(true);
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view)).setChildSelector((IsWidget)Mockito.any());
        ((MultiplePermissionNodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setClearChildrenEnabled(true);
        ((LeafPermissionNodeEditor)Mockito.verify((Object)this.childEditor1)).edit((PermissionNode)this.permissionChildNode1);
        ((LeafPermissionNodeEditor)Mockito.verify((Object)this.childEditor2)).edit((PermissionNode)this.permissionChildNode2);
    }

    @Test
    public void testSwitchChange() {
        this.presenter.edit((PermissionNode)this.permissionGroupNode);
        this.permissionSwitchRead.onChange();
        ((Permission)Mockito.verify((Object)this.permissionRead)).setResult((AuthorizationResult)Mockito.any());
        ((Event)Mockito.verify(this.changedEvent)).fire((Object)((PermissionChangedEvent)Mockito.any()));
    }

    @Test
    public void testSwitchInitDependencies() {
        Mockito.when((Object)this.permissionSwitchReadView.isOn()).thenReturn((Object)false);
        this.presenter.edit((PermissionNode)this.permissionGroupNode);
        ((Permission)Mockito.verify((Object)this.permissionUpdate)).setResult(AuthorizationResult.ACCESS_DENIED);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setEnabled(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setOn(false);
    }

    @Test
    public void testSwitchChangeDependencies() {
        this.presenter.edit((PermissionNode)this.permissionGroupNode);
        Mockito.reset((Object[])new Permission[]{this.permissionUpdate});
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitchUpdate});
        Mockito.when((Object)this.permissionSwitchRead.isOn()).thenReturn((Object)false);
        this.permissionSwitchRead.onChange();
        ((Permission)Mockito.verify((Object)this.permissionUpdate)).setResult(AuthorizationResult.ACCESS_DENIED);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setEnabled(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setOn(false);
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitchUpdate});
        Mockito.when((Object)this.permissionSwitchRead.isOn()).thenReturn((Object)true);
        this.permissionSwitchRead.onChange();
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setEnabled(true);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate, (VerificationMode)Mockito.never())).setOn(Mockito.anyBoolean());
    }

    @Test
    public void testSwitchChildDependencies() {
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        this.permissionSwitchReadView1.setExceptionEnabled(false);
        this.permissionSwitchUpdateView1.setExceptionEnabled(false);
        Mockito.reset((Object[])new Permission[]{this.permissionUpdate});
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitchRead});
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitchUpdate});
        Mockito.when((Object)this.permissionSwitchRead.isOn()).thenReturn((Object)false);
        this.permissionSwitchRead.onChange();
        this.permissionSwitchReadView1.setExceptionEnabled(false);
        this.permissionSwitchUpdateView1.setExceptionEnabled(false);
        ((Permission)Mockito.verify((Object)this.permissionUpdate)).setResult(AuthorizationResult.ACCESS_DENIED);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setEnabled(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setOn(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setNumberOfExceptions(0);
    }

    @Test
    public void testChildrenSwitchExceptions() {
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        Mockito.when((Object)this.permissionSwitchReadView1.isOn()).thenReturn((Object)true);
        this.permissionSwitchRead1.onChange();
        ((Permission)Mockito.verify((Object)this.permissionRead1)).setResult(AuthorizationResult.ACCESS_GRANTED);
        ((PermissionExceptionSwitch.View)Mockito.verify((Object)this.permissionSwitchReadView1)).setExceptionEnabled(false);
        Mockito.reset((Object[])new Permission[]{this.permissionUpdate});
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitchRead});
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitchUpdate});
        Mockito.reset((Object[])new PermissionExceptionSwitch.View[]{this.permissionSwitchUpdateView1});
        this.permissionSwitchRead.onChange();
        ((Permission)Mockito.verify((Object)this.permissionUpdate)).setResult(AuthorizationResult.ACCESS_DENIED);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setEnabled(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setOn(false);
        ((PermissionExceptionSwitch.View)Mockito.verify((Object)this.permissionSwitchUpdateView1, (VerificationMode)Mockito.atLeastOnce())).setExceptionEnabled(false);
        Mockito.reset((Object[])new Permission[]{this.permissionUpdate});
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitchRead});
        Mockito.reset((Object[])new PermissionSwitch[]{this.permissionSwitchUpdate});
        Mockito.reset((Object[])new PermissionExceptionSwitch.View[]{this.permissionSwitchUpdateView1});
        Mockito.when((Object)this.permissionSwitchReadView.isOn()).thenReturn((Object)false);
        this.permissionSwitchRead.onChange();
        ((Permission)Mockito.verify((Object)this.permissionUpdate)).setResult(AuthorizationResult.ACCESS_DENIED);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setEnabled(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setOn(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setNumberOfExceptions(0);
        ((Permission)Mockito.verify((Object)this.permissionUpdate1)).setResult(AuthorizationResult.ACCESS_DENIED);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setEnabled(false);
        ((PermissionSwitch)Mockito.verify((Object)this.permissionSwitchUpdate)).setOn(false);
        ((PermissionExceptionSwitch.View)Mockito.verify((Object)this.permissionSwitchUpdateView1, (VerificationMode)Mockito.atLeastOnce())).setExceptionEnabled(false);
    }

    @Test
    public void testAddChildDropDownEmpty() {
        this.permissionResourceChildrenAdded.clear();
        this.permissionResourceChildrenAdded.add((PermissionNode)this.permissionChildNode1);
        this.permissionResourceChildrenAdded.add((PermissionNode)this.permissionChildNode2);
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        LiveSearchService searchService = this.presenter.getChildrenSearchService();
        searchService.search("", -1, results -> Assert.assertEquals((long)results.size(), (long)0L));
    }

    @Test
    public void testAddChildDropDownFull() {
        this.permissionResourceChildrenAdded.clear();
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        LiveSearchService searchService = this.presenter.getChildrenSearchService();
        searchService.search("", -1, results -> Assert.assertEquals((long)results.size(), (long)2L));
    }

    @Test
    public void testAddChildDropDownDuplicateNames() {
        this.permissionResourceChildrenAdded.clear();
        this.permissionResourceChildrenAdded.add((PermissionNode)this.permissionChildNode2);
        PermissionLeafNode permissionChildNode3 = new PermissionLeafNode();
        permissionChildNode3.addPermission((Permission)new DotNamedPermission("read.p1b", Boolean.valueOf(true)), "", "");
        permissionChildNode3.setNodeName("p1");
        this.permissionResourceChildrenAvailable.add((PermissionNode)permissionChildNode3);
        this.presenter.edit((PermissionNode)this.permissionResourceNode);
        LiveSearchService searchService = this.presenter.getChildrenSearchService();
        searchService.search("", -1, results -> {
            Assert.assertEquals((long)results.size(), (long)2L);
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(0)).getKey(), (Object)"read.p1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(0)).getValue(), (Object)"p1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(1)).getKey(), (Object)"read.p1b");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(1)).getValue(), (Object)"p1");
        });
    }

    class TestPermissionProvider
    implements PermissionTreeProvider {
        TestPermissionProvider() {
        }

        public PermissionNode buildRootNode() {
            return null;
        }

        public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback consumer) {
            consumer.afterLoad(MultiplePermissionNodeEditorTest.this.permissionResourceChildrenAvailable);
        }
    }
}

