/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsEditor;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserGroupsEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.explorer.ExplorerViewContext;
import org.uberfire.ext.security.management.client.widgets.management.explorer.GroupsExplorer;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserAssignedGroupsEditorTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    @Mock
    EventSourceMock<OnUpdateUserGroupsEvent> updateUserGroupsEventEvent;
    @Mock
    GroupsExplorer groupsExplorer;
    @Mock
    AssignedEntitiesEditor<UserAssignedGroupsEditor> view;
    @Mock
    User user;
    private UserAssignedGroupsEditor tested;

    @Before
    public void setup() {
        HashMap<String, String> userAttributes = new HashMap<String, String>(1);
        userAttributes.put("attr1", "value1");
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.user.getProperties()).thenReturn(userAttributes);
        HashSet<GroupImpl> groups = new HashSet<GroupImpl>();
        groups.add(new GroupImpl("group1"));
        Mockito.when((Object)this.user.getGroups()).thenReturn(groups);
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<Group>(){

            public Group answer(InvocationOnMock invocationOnMock) throws Throwable {
                Group group = (Group)Mockito.mock(Group.class);
                return group;
            }
        }).when((Object)this.userSystemManager)).createGroup(ArgumentMatchers.anyString());
        Mockito.when((Object)this.userSystemManager.isUserCapabilityEnabled((Capability)ArgumentMatchers.any(Capability.class))).thenReturn((Object)true);
        this.tested = new UserAssignedGroupsEditor(this.userSystemManager, this.groupsExplorer, this.view, this.updateUserGroupsEventEvent);
    }

    @Test
    public void testInit() {
        this.tested.init();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.tested);
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).configure((EntitiesExplorerView)ArgumentMatchers.any());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).setPageSize(ArgumentMatchers.anyInt());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).hide();
    }

    @Test
    public void testClear() {
        this.tested.clear();
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        Assert.assertTrue((boolean)this.tested.entities.isEmpty());
        this.assertNoViewCalls();
    }

    @Test
    public void testHide() {
        this.tested.hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((UserAssignedGroupsEditor)ArgumentMatchers.any(UserAssignedGroupsEditor.class)));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testShow() {
        this.tested.show(this.user);
        Assert.assertFalse((boolean)this.tested.isEditMode);
        Assert.assertTrue((this.tested.entities.size() == 1 ? 1 : 0) != 0);
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).show((ExplorerViewContext)ArgumentMatchers.any(ExplorerViewContext.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((UserAssignedGroupsEditor)ArgumentMatchers.any(UserAssignedGroupsEditor.class)));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testEdit() {
        this.tested.edit(this.user);
        Assert.assertTrue((boolean)this.tested.isEditMode);
        Assert.assertTrue((this.tested.entities.size() == 1 ? 1 : 0) != 0);
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).show((ExplorerViewContext)ArgumentMatchers.any(ExplorerViewContext.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((UserAssignedGroupsEditor)ArgumentMatchers.any(UserAssignedGroupsEditor.class)));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testCloseEditorCallback() {
        this.tested.closeEditorCallback.execute();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((UserAssignedGroupsEditor)ArgumentMatchers.any(UserAssignedGroupsEditor.class)));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testSaveEditorCallback() {
        HashSet<String> selectedGroups = new HashSet<String>();
        selectedGroups.add("groupE1");
        Mockito.when((Object)this.groupsExplorer.getSelectedEntities()).thenReturn(selectedGroups);
        this.tested.saveEditorCallback.execute();
        Assert.assertTrue((this.tested.entities.size() == 1 ? 1 : 0) != 0);
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).getSelectedEntities();
        ((GroupsExplorer)Mockito.verify((Object)this.groupsExplorer, (VerificationMode)Mockito.times((int)1))).clear();
        ((EventSourceMock)Mockito.verify(this.updateUserGroupsEventEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((OnUpdateUserGroupsEvent)ArgumentMatchers.any(OnUpdateUserGroupsEvent.class)));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((UserAssignedGroupsEditor)ArgumentMatchers.any(UserAssignedGroupsEditor.class)));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }

    private void assertNoViewCalls() {
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((UserAssignedGroupsEditor)ArgumentMatchers.any(UserAssignedGroupsEditor.class)));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configure((EntitiesExplorerView)ArgumentMatchers.any(EntitiesExplorerView.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).hide();
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureClose(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
        ((AssignedEntitiesEditor)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).configureSave(ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class));
    }
}

