/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.services.shared.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;

@Portable
public class MultiGridPreferencesStore
extends UserPreference {
    private String multiGridId;
    private HashMap<String, HashMap> gridsSettings = new HashMap();
    private ArrayList<String> gridsIds = new ArrayList();
    private String selectedGrid = "NONE";
    private int refreshInterval = 10;
    private String defaultGridId = "";

    public MultiGridPreferencesStore() {
    }

    public MultiGridPreferencesStore(String multiGridId) {
        this.multiGridId = multiGridId;
        this.type = UserPreferencesType.MULTIGRIDPREFERENCES;
        this.preferenceKey = multiGridId;
    }

    public String getMultiGridId() {
        return this.multiGridId;
    }

    public void setMultiGridId(String multiGridId) {
        this.multiGridId = multiGridId;
    }

    public HashMap getGridSettings(String key) {
        if (this.gridsSettings != null) {
            return this.gridsSettings.get(key);
        }
        return null;
    }

    public String getGridSettingParam(String key, String paramId) {
        HashMap params = this.getGridSettings(key);
        if (params != null) {
            return (String)params.get(paramId);
        }
        return null;
    }

    public void setGridSettings(String key, HashMap params) {
        this.gridsSettings.put(key, params);
    }

    public ArrayList<String> getGridsId() {
        return this.gridsIds;
    }

    public void addGridId(String gridKey) {
        this.getGridsId().add(gridKey);
    }

    public void addNewTab(String gridKey, HashMap gridsSettings) {
        this.addGridId(gridKey);
        this.setGridSettings(gridKey, gridsSettings);
    }

    public void removeTab(String gridKey) {
        this.gridsSettings.remove(gridKey);
        for (int i = 0; i < this.getGridsId().size(); ++i) {
            if (!this.gridsIds.get(i).equals(gridKey)) continue;
            this.gridsIds.remove(i);
        }
        if (this.isSelectedGrid(gridKey)) {
            this.selectedGrid = "";
        }
    }

    public boolean isSelectedGrid(String gridKey) {
        if (this.selectedGrid != null) {
            return this.selectedGrid.equals(gridKey);
        }
        return false;
    }

    public String getSelectedGrid() {
        return this.selectedGrid;
    }

    public void setSelectedGrid(String gridKey) {
        this.selectedGrid = gridKey;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public String getDefaultGridId() {
        return this.defaultGridId;
    }

    public void setDefaultGridId(String defaultGridId) {
        this.defaultGridId = defaultGridId;
    }
}

