/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.services.backend.preferences;

import com.thoughtworks.xstream.XStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.server.UserServicesBackendImpl;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserDataGridPreferencesService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
public class UserDataGridPreferencesServiceImpl
implements UserDataGridPreferencesService {
    @Inject
    private UserServicesBackendImpl userServicesBackend;
    @Inject
    private User identity;
    @Inject
    @Named(value="configIO")
    private IOService ioServiceConfig;
    private XStream xs = new XStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGridPreferences(GridPreferencesStore preferences) {
        Path preferencesPath = this.userServicesBackend.buildPath(this.identity.getIdentifier(), "datagrid-preferences", preferences.getGlobalPreferences().getKey());
        try {
            this.ioServiceConfig.startBatch(preferencesPath.getFileSystem());
            this.ioServiceConfig.write(preferencesPath, this.xs.toXML((Object)preferences), new OpenOption[0]);
        }
        finally {
            this.ioServiceConfig.endBatch();
        }
    }

    public GridPreferencesStore loadGridPreferences(String key) {
        Path preferencesPath = this.userServicesBackend.buildPath(this.identity.getIdentifier(), "datagrid-preferences", key);
        try {
            if (this.ioServiceConfig.exists(preferencesPath)) {
                String xml = this.ioServiceConfig.readAllString(preferencesPath);
                return (GridPreferencesStore)this.xs.fromXML(xml);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

