/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.services.backend.preferences;

import com.thoughtworks.xstream.XStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.xstream.XStreamUtils;
import org.uberfire.backend.server.UserServicesBackendImpl;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
public class UserPreferencesServiceImpl
implements UserPreferencesService {
    @Inject
    private UserServicesBackendImpl userServicesBackend;
    @Inject
    private User identity;
    @Inject
    @Named(value="configIO")
    private IOService ioServiceConfig;
    private XStream xs = XStreamUtils.createTrustingXStream();

    public void saveUserPreferences(UserPreference preferences) {
        Path preferencesPath = this.userServicesBackend.buildPath(this.identity.getIdentifier(), preferences.getType().getExt(), preferences.getPreferenceKey());
        this.saveUserPreferences(preferences, preferencesPath);
    }

    public UserPreference loadUserPreferences(String key, UserPreferencesType type) {
        Path preferencesPath = this.userServicesBackend.buildPath(this.identity.getIdentifier(), type.getExt(), key);
        return this.loadUserPreferences(preferencesPath);
    }

    private void saveUserPreferences(UserPreference preferences, Path path) {
        try {
            this.ioServiceConfig.startBatch(path.getFileSystem());
            this.ioServiceConfig.write(path, this.xs.toXML((Object)preferences), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ioServiceConfig.endBatch();
        }
    }

    private UserPreference loadUserPreferences(Path path) {
        try {
            if (this.ioServiceConfig.exists(path)) {
                String xml = this.ioServiceConfig.readAllString(path);
                return (UserPreference)this.xs.fromXML(xml);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public UserPreference loadUserPreferences(UserPreference preferences) {
        Path preferencesPath = this.userServicesBackend.buildPath(this.identity.getIdentifier(), preferences.getType().getExt(), preferences.getPreferenceKey());
        return this.loadUserPreferences(preferencesPath);
    }
}

