/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.api.model.impl.nodes;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Content;
import org.uberfire.ext.wires.bpmn.api.model.Property;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.impl.content.DefaultContentImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.properties.DefaultPropertyImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.roles.DefaultRoleImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.types.StringType;
import org.uberfire.ext.wires.bpmn.beliefs.graph.Graph;
import org.uberfire.ext.wires.bpmn.beliefs.graph.impl.GraphImpl;
import org.uberfire.ext.wires.bpmn.beliefs.graph.impl.GraphNodeImpl;
import org.uberfire.ext.wires.bpmn.beliefs.graph.impl.MapGraphStore;

@Portable
public class ProcessNode
extends GraphNodeImpl<Content, BpmnEdge>
implements BpmnGraph,
BpmnGraphNode {
    private Graph<Content, BpmnGraphNode> graph = new GraphImpl<Content, BpmnGraphNode>(new MapGraphStore());
    private Set<Role> roles = new HashSet<Role>(){
        {
            this.add(new DefaultRoleImpl("canContainArtifacts"));
        }
    };
    private Set<Property> properties = new HashSet<Property>(){
        {
            this.add(new DefaultPropertyImpl("processn", new StringType(), "Process Name", "Process Name", false, false));
            this.add(new DefaultPropertyImpl("documentation", new StringType(), "Documentation", "This attribute is used to annotate the BPMN element, such as descriptions and other documentation.", false, true));
        }
    };

    public ProcessNode() {
        this.setContent(new DefaultContentImpl("BPMNProcess", "BPMN-Process", "A BPMN 2.0 Process.", this.roles, this.properties));
    }

    @Override
    public BpmnGraphNode addNode(BpmnGraphNode node) {
        return this.graph.addNode(node);
    }

    @Override
    public BpmnGraphNode removeNode(int id) {
        return this.graph.removeNode(id);
    }

    @Override
    public BpmnGraphNode getNode(int id) {
        return this.graph.getNode(id);
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public Iterator<BpmnGraphNode> iterator() {
        return this.graph.iterator();
    }

    @Override
    public ProcessNode copy() {
        ProcessNode copy = new ProcessNode();
        copy.setContent(((Content)this.getContent()).copy());
        for (BpmnGraphNode node : this.graph) {
            copy.addNode((BpmnGraphNode)node.copy());
        }
        return copy;
    }

    @Override
    public String toString() {
        return "ProcessNode{graph=" + this.graph + ", roles=" + this.roles + ", properties=" + this.properties + '}';
    }
}

