/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.api.model.impl.rules;

import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.rules.CardinalityRule;

@Portable
public class CardinalityRuleImpl
implements CardinalityRule {
    private String name;
    private Role role;
    private long minOccurrences = 0L;
    private long maxOccurrences = 0L;
    private Set<CardinalityRule.ConnectorRule> incomingConnectionRules = new HashSet<CardinalityRule.ConnectorRule>();
    private Set<CardinalityRule.ConnectorRule> outgoingConnectionRules = new HashSet<CardinalityRule.ConnectorRule>();

    public CardinalityRuleImpl(@MapsTo(value="name") String name, @MapsTo(value="role") Role role, @MapsTo(value="minOccurrences") long minOccurrences, @MapsTo(value="maxOccurrences") long maxOccurrences, @MapsTo(value="incomingConnectionRules") Set<CardinalityRule.ConnectorRule> incomingConnectionRules, @MapsTo(value="outgoingConnectionRules") Set<CardinalityRule.ConnectorRule> outgoingConnectionRules) {
        long crMaxOccurrences;
        long crMinOccurrences;
        this.name = (String)PortablePreconditions.checkNotNull((String)"name", (Object)name);
        this.role = (Role)PortablePreconditions.checkNotNull((String)"role", (Object)role);
        if (minOccurrences < 0L) {
            throw new IllegalArgumentException("minOccurrences cannot be less than 0.");
        }
        this.minOccurrences = minOccurrences;
        if (maxOccurrences < minOccurrences) {
            throw new IllegalArgumentException("maxOccurrences cannot be less than minOccurrences.");
        }
        this.maxOccurrences = maxOccurrences;
        for (CardinalityRule.ConnectorRule cr : incomingConnectionRules) {
            crMinOccurrences = cr.getMinOccurrences();
            crMaxOccurrences = cr.getMaxOccurrences();
            if (crMinOccurrences < 0L) {
                throw new IllegalArgumentException("Incoming ConnectorRule minOccurrences cannot be less than 0.");
            }
            if (crMaxOccurrences >= crMinOccurrences) continue;
            throw new IllegalArgumentException("Incoming ConnectorRule maxOccurrences cannot be less than minOccurrences.");
        }
        this.incomingConnectionRules = (Set)PortablePreconditions.checkNotNull((String)"incomingConnectionRules", incomingConnectionRules);
        for (CardinalityRule.ConnectorRule cr : outgoingConnectionRules) {
            crMinOccurrences = cr.getMinOccurrences();
            crMaxOccurrences = cr.getMaxOccurrences();
            if (crMinOccurrences < 0L) {
                throw new IllegalArgumentException("Outgoing ConnectorRule minOccurrences cannot be less than 0.");
            }
            if (crMaxOccurrences >= crMinOccurrences) continue;
            throw new IllegalArgumentException("Outgoing ConnectorRule maxOccurrences cannot be less than minOccurrences.");
        }
        this.outgoingConnectionRules = (Set)PortablePreconditions.checkNotNull((String)"outgoingConnectionRules", outgoingConnectionRules);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public long getMinOccurrences() {
        return this.minOccurrences;
    }

    @Override
    public long getMaxOccurrences() {
        return this.maxOccurrences;
    }

    @Override
    public Set<CardinalityRule.ConnectorRule> getIncomingConnectionRules() {
        return this.incomingConnectionRules;
    }

    @Override
    public Set<CardinalityRule.ConnectorRule> getOutgoingConnectionRules() {
        return this.outgoingConnectionRules;
    }
}

