/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.AddEdgeCommand;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultImpl;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultsImpl;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;

public class DeleteEdgeCommand
implements Command {
    private BpmnGraphNode outgoingNode;
    private BpmnGraphNode incomingNode;
    private BpmnEdge edge;

    public DeleteEdgeCommand(BpmnGraphNode outgoingNode, BpmnGraphNode incomingNode, BpmnEdge edge) {
        this.outgoingNode = (BpmnGraphNode)PortablePreconditions.checkNotNull((String)"outgoingNode", (Object)outgoingNode);
        this.incomingNode = (BpmnGraphNode)PortablePreconditions.checkNotNull((String)"incomingNode", (Object)incomingNode);
        this.edge = (BpmnEdge)PortablePreconditions.checkNotNull((String)"edge", (Object)edge);
    }

    @Override
    public Results apply(RuleManager ruleManager) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        boolean isEdgeOutgoing = false;
        boolean isEdgeIncoming = false;
        for (BpmnEdge e : this.outgoingNode.getOutEdges()) {
            if (!e.equals(this.edge)) continue;
            isEdgeOutgoing = true;
            break;
        }
        for (BpmnEdge e : this.incomingNode.getInEdges()) {
            if (!e.equals(this.edge)) continue;
            isEdgeIncoming = true;
            break;
        }
        if (isEdgeOutgoing && isEdgeIncoming) {
            results.getMessages().addAll(ruleManager.checkCardinality(this.outgoingNode, this.incomingNode, this.edge, RuleManager.Operation.DELETE).getMessages());
            if (!results.contains(ResultType.ERROR)) {
                this.outgoingNode.getOutEdges().remove(this.edge);
                this.incomingNode.getInEdges().remove(this.edge);
            }
        } else {
            results.addMessage(new DefaultResultImpl(ResultType.WARNING, "The Edge does not connect the given GraphNodes and hence was not deleted."));
        }
        return results;
    }

    @Override
    public Results undo(RuleManager ruleManager) {
        AddEdgeCommand undoCommand = new AddEdgeCommand(this.outgoingNode, this.incomingNode, this.edge);
        return undoCommand.apply(ruleManager);
    }
}

