/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.commands.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.bpmn.client.commands.Command;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultsImpl;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;

public class BatchCommand
implements Command {
    private List<Command> commands;

    public BatchCommand(List<Command> commands) {
        this.commands = (List)PortablePreconditions.checkNotNull((String)"commands", commands);
    }

    public BatchCommand(Command ... commands) {
        this.commands = Arrays.asList((Object[])PortablePreconditions.checkNotNull((String)"commands", (Object)commands));
    }

    @Override
    public Results apply(RuleManager ruleManager) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        Stack<Command> appliedCommands = new Stack<Command>();
        for (Command command : this.commands) {
            results.getMessages().addAll(command.apply(ruleManager).getMessages());
            if (results.contains(ResultType.ERROR)) {
                for (Command undo : appliedCommands) {
                    undo.undo(ruleManager);
                }
                return results;
            }
            appliedCommands.add(command);
        }
        return results;
    }

    @Override
    public Results undo(RuleManager ruleManager) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        Stack<Command> appliedCommands = new Stack<Command>();
        for (Command command : this.commands) {
            results.getMessages().addAll(command.undo(ruleManager).getMessages());
            if (results.contains(ResultType.ERROR)) {
                for (Command cmd : appliedCommands) {
                    cmd.apply(ruleManager);
                }
                return results;
            }
            appliedCommands.add(command);
        }
        return results;
    }
}

