/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.rules.impl;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Content;
import org.uberfire.ext.wires.bpmn.api.model.rules.CardinalityRule;
import org.uberfire.ext.wires.bpmn.api.model.rules.ConnectionRule;
import org.uberfire.ext.wires.bpmn.api.model.rules.ContainmentRule;
import org.uberfire.ext.wires.bpmn.api.model.rules.Rule;
import org.uberfire.ext.wires.bpmn.client.commands.ResultType;
import org.uberfire.ext.wires.bpmn.client.commands.Results;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultImpl;
import org.uberfire.ext.wires.bpmn.client.commands.impl.DefaultResultsImpl;
import org.uberfire.ext.wires.bpmn.client.rules.RuleManager;

@ApplicationScoped
public class DefaultRuleManagerImpl
implements RuleManager {
    private final Set<ContainmentRule> containmentRules = new HashSet<ContainmentRule>();
    private final Set<CardinalityRule> cardinalityRules = new HashSet<CardinalityRule>();
    private final Set<ConnectionRule> connectionRules = new HashSet<ConnectionRule>();

    @Override
    public void addRule(Rule rule) {
        PortablePreconditions.checkNotNull((String)"rule", (Object)rule);
        if (rule instanceof ContainmentRule) {
            this.containmentRules.add((ContainmentRule)rule);
        } else if (rule instanceof CardinalityRule) {
            this.cardinalityRules.add((CardinalityRule)rule);
        } else if (rule instanceof ConnectionRule) {
            this.connectionRules.add((ConnectionRule)rule);
        }
    }

    @Override
    public Results checkContainment(BpmnGraph target, BpmnGraphNode candidate) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        if (this.containmentRules.isEmpty()) {
            return results;
        }
        for (ContainmentRule rule : this.containmentRules) {
            if (!rule.getId().equals(((Content)target.getContent()).getId())) continue;
            HashSet permittedRoles = new HashSet(rule.getPermittedRoles());
            permittedRoles.retainAll(((Content)candidate.getContent()).getRoles());
            if (permittedRoles.size() <= 0) continue;
            return results;
        }
        results.addMessage(new DefaultResultImpl(ResultType.ERROR, "'" + ((Content)target.getContent()).getId() + "' cannot contain '" + ((Content)candidate.getContent()).getId() + "'."));
        return results;
    }

    @Override
    public Results checkCardinality(BpmnGraph target, BpmnGraphNode candidate, RuleManager.Operation operation) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        if (this.cardinalityRules.isEmpty()) {
            return results;
        }
        for (CardinalityRule rule : this.cardinalityRules) {
            if (!((Content)candidate.getContent()).getRoles().contains(rule.getRole())) continue;
            long minOccurrences = rule.getMinOccurrences();
            long maxOccurrences = rule.getMaxOccurrences();
            long count = operation == RuleManager.Operation.ADD ? 1 : -1;
            for (BpmnGraphNode node : target) {
                if (!((Content)node.getContent()).getId().equals(((Content)candidate.getContent()).getId())) continue;
                ++count;
            }
            if (count < minOccurrences) {
                results.addMessage(new DefaultResultImpl(ResultType.ERROR, "'" + ((Content)target.getContent()).getId() + "' needs a minimum '" + minOccurrences + "' of '" + ((Content)candidate.getContent()).getId() + "' nodes. Found '" + count + "'."));
                continue;
            }
            if (count <= maxOccurrences) continue;
            results.addMessage(new DefaultResultImpl(ResultType.ERROR, "'" + ((Content)target.getContent()).getId() + "' can have a maximum  '" + maxOccurrences + "' of '" + ((Content)candidate.getContent()).getId() + "' nodes. Found '" + count + "'."));
        }
        return results;
    }

    @Override
    public Results checkConnectionRules(BpmnGraphNode outgoingNode, BpmnGraphNode incomingNode, BpmnEdge edge) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        if (this.connectionRules.isEmpty()) {
            return results;
        }
        HashSet<Pair> couples = new HashSet<Pair>();
        for (ConnectionRule rule : this.connectionRules) {
            if (!edge.getRole().equals(rule.getRole())) continue;
            for (ConnectionRule.PermittedConnection pc : rule.getPermittedConnections()) {
                couples.add(new Pair((Object)pc.getStartRole().getName(), (Object)pc.getEndRole().getName()));
                if (!((Content)outgoingNode.getContent()).getRoles().contains(pc.getStartRole()) || !((Content)incomingNode.getContent()).getRoles().contains(pc.getEndRole())) continue;
                return results;
            }
        }
        results.addMessage(new DefaultResultImpl(ResultType.ERROR, "Edge does not emanate from a GraphNode with a permitted Role nor terminate at GraphNode with a permitted Role. Permitted Connections are: " + ((Object)couples).toString()));
        return results;
    }

    @Override
    public Results checkCardinality(BpmnGraphNode outgoingNode, BpmnGraphNode incomingNode, BpmnEdge edge, RuleManager.Operation operation) {
        DefaultResultsImpl results = new DefaultResultsImpl();
        if (this.cardinalityRules.isEmpty()) {
            return results;
        }
        for (CardinalityRule rule : this.cardinalityRules) {
            BpmnEdge be;
            long count;
            long maxOccurrences;
            long minOccurrences;
            if (((Content)outgoingNode.getContent()).getRoles().contains(rule.getRole())) {
                for (CardinalityRule.ConnectorRule cr : rule.getOutgoingConnectionRules()) {
                    if (!cr.getRole().equals(edge.getRole())) continue;
                    minOccurrences = cr.getMinOccurrences();
                    maxOccurrences = cr.getMaxOccurrences();
                    count = operation == RuleManager.Operation.ADD ? 1 : -1;
                    for (BpmnEdge e : outgoingNode.getOutEdges()) {
                        if (!(e instanceof BpmnEdge) || !(be = e).getRole().equals(edge.getRole())) continue;
                        ++count;
                    }
                    if (count < minOccurrences) {
                        results.addMessage(new DefaultResultImpl(ResultType.ERROR, "'" + ((Content)outgoingNode.getContent()).getId() + "' needs a minimum '" + minOccurrences + "' of '" + cr.getRole() + "' edges. Found '" + count + "'."));
                        continue;
                    }
                    if (count <= maxOccurrences) continue;
                    results.addMessage(new DefaultResultImpl(ResultType.ERROR, "'" + ((Content)outgoingNode.getContent()).getId() + "' can have a maximum  '" + maxOccurrences + "' of '" + cr.getRole() + "' edges. Found '" + count + "'."));
                }
            }
            if (!((Content)incomingNode.getContent()).getRoles().contains(rule.getRole())) continue;
            for (CardinalityRule.ConnectorRule cr : rule.getIncomingConnectionRules()) {
                if (!cr.getRole().equals(edge.getRole())) continue;
                minOccurrences = cr.getMinOccurrences();
                maxOccurrences = cr.getMaxOccurrences();
                count = operation == RuleManager.Operation.ADD ? 1 : -1;
                for (BpmnEdge e : incomingNode.getInEdges()) {
                    if (!(e instanceof BpmnEdge) || !(be = e).getRole().equals(edge.getRole())) continue;
                    ++count;
                }
                if (count < minOccurrences) {
                    results.addMessage(new DefaultResultImpl(ResultType.ERROR, "'" + ((Content)incomingNode.getContent()).getId() + "' needs a minimum '" + minOccurrences + "' of '" + cr.getRole() + "' edges. Found '" + count + "'."));
                    continue;
                }
                if (count <= maxOccurrences) continue;
                results.addMessage(new DefaultResultImpl(ResultType.ERROR, "'" + ((Content)incomingNode.getContent()).getId() + "' can have a maximum  '" + maxOccurrences + "' of '" + cr.getRole() + "' edges. Found '" + count + "'."));
            }
        }
        return results;
    }
}

