/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.uberfire.ext.wires.bpmn.api.model.BpmnEdge;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraph;
import org.uberfire.ext.wires.bpmn.api.model.BpmnGraphNode;
import org.uberfire.ext.wires.bpmn.api.model.Content;
import org.uberfire.ext.wires.bpmn.api.model.Role;
import org.uberfire.ext.wires.bpmn.api.model.impl.nodes.ProcessNode;
import org.uberfire.ext.wires.bpmn.api.model.impl.roles.DefaultRoleImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.rules.CardinalityRuleImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.rules.ConnectionRuleImpl;
import org.uberfire.ext.wires.bpmn.api.model.impl.rules.ContainmentRuleImpl;
import org.uberfire.ext.wires.bpmn.api.model.rules.CardinalityRule;
import org.uberfire.ext.wires.bpmn.api.model.rules.ConnectionRule;
import org.uberfire.ext.wires.bpmn.api.model.rules.Rule;

public abstract class AbstractBaseRuleTest {
    protected Set<Rule> getContainmentRules() {
        HashSet<Rule> rules = new HashSet<Rule>();
        rules.add((Rule)new ContainmentRuleImpl("Process Node Containment Rule", ((Content)new ProcessNode().getContent()).getId(), (Set)new HashSet<Role>(){
            {
                this.add(new DefaultRoleImpl("all"));
            }
        }));
        return rules;
    }

    protected Set<Rule> getCardinalityRules() {
        HashSet<Rule> rules = new HashSet<Rule>();
        rules.add((Rule)new CardinalityRuleImpl("Start Node Cardinality Rule", (Role)new DefaultRoleImpl("sequence_start"), 0L, 1L, Collections.EMPTY_SET, (Set)new HashSet<CardinalityRule.ConnectorRule>(){
            {
                this.add(new CardinalityRule.ConnectorRule(){

                    public long getMinOccurrences() {
                        return 0L;
                    }

                    public long getMaxOccurrences() {
                        return 1L;
                    }

                    public Role getRole() {
                        return new DefaultRoleImpl("general_edge");
                    }

                    public String getName() {
                        return "Start Node Outgoing Connector Rule 1";
                    }
                });
            }
        }));
        rules.add((Rule)new CardinalityRuleImpl("End Node Cardinality Rule", (Role)new DefaultRoleImpl("sequence_end"), 0L, 1L, (Set)new HashSet<CardinalityRule.ConnectorRule>(){
            {
                this.add(new CardinalityRule.ConnectorRule(){

                    public long getMinOccurrences() {
                        return 0L;
                    }

                    public long getMaxOccurrences() {
                        return 1L;
                    }

                    public Role getRole() {
                        return new DefaultRoleImpl("general_edge");
                    }

                    public String getName() {
                        return "End Node Incoming Connector Rule 1";
                    }
                });
            }
        }, Collections.EMPTY_SET));
        return rules;
    }

    protected Set<Rule> getConnectionRules() {
        HashSet<Rule> rules = new HashSet<Rule>();
        rules.add((Rule)new ConnectionRuleImpl("StartNode to TestDummyNode Connector Rule", (Role)new DefaultRoleImpl("general_edge"), (Set)new HashSet<ConnectionRule.PermittedConnection>(){
            {
                this.add(new ConnectionRule.PermittedConnection(){

                    public Role getStartRole() {
                        return new DefaultRoleImpl("sequence_start");
                    }

                    public Role getEndRole() {
                        return new DefaultRoleImpl("dummy");
                    }
                });
                this.add(new ConnectionRule.PermittedConnection(){

                    public Role getStartRole() {
                        return new DefaultRoleImpl("dummy");
                    }

                    public Role getEndRole() {
                        return new DefaultRoleImpl("sequence_end");
                    }
                });
                this.add(new ConnectionRule.PermittedConnection(){

                    public Role getStartRole() {
                        return new DefaultRoleImpl("dummy");
                    }

                    public Role getEndRole() {
                        return new DefaultRoleImpl("dummy");
                    }
                });
            }
        }));
        return rules;
    }

    protected void assertProcessContainsNodes(BpmnGraph graph, BpmnGraphNode ... nodes) {
        HashSet<BpmnGraphNode> nodesToExist = new HashSet<BpmnGraphNode>();
        for (BpmnGraphNode node : nodes) {
            nodesToExist.add(node);
        }
        for (BpmnGraphNode gn : graph) {
            for (BpmnGraphNode node : nodes) {
                if (!gn.equals(node)) continue;
                nodesToExist.remove(node);
            }
        }
        if (!nodesToExist.isEmpty()) {
            StringBuffer sb = new StringBuffer("Not all GraphNodes were present in Graph.\n");
            for (BpmnGraphNode node : nodesToExist) {
                sb.append("--> Not present: GraphNode [" + node.toString() + "].\n");
            }
            Assert.fail((String)sb.toString());
        }
    }

    protected void assertProcessNotContainsNodes(BpmnGraph graph, BpmnGraphNode ... nodes) {
        HashSet<BpmnGraphNode> nodesToNotExist = new HashSet<BpmnGraphNode>();
        for (BpmnGraphNode gn : graph) {
            for (BpmnGraphNode node : nodes) {
                if (!gn.equals(node)) continue;
                nodesToNotExist.add(node);
            }
        }
        if (!nodesToNotExist.isEmpty()) {
            StringBuffer sb = new StringBuffer("One or more GraphNodes were present in Graph.\n");
            for (BpmnGraphNode node : nodesToNotExist) {
                sb.append("--> Present: GraphNode [" + node.toString() + "].\n");
            }
            Assert.fail((String)sb.toString());
        }
    }

    protected void assertNodeContainsOutgoingEdges(BpmnGraphNode node, BpmnEdge ... edges) {
        HashSet<BpmnEdge> edgesToExist = new HashSet<BpmnEdge>();
        for (BpmnEdge edge : edges) {
            edgesToExist.add(edge);
        }
        for (BpmnEdge edge : node.getOutEdges()) {
            for (BpmnEdge be : edges) {
                if (!be.equals(edge)) continue;
                edgesToExist.remove(edge);
            }
        }
        if (!edgesToExist.isEmpty()) {
            StringBuffer sb = new StringBuffer("Not all Edges were present in GraphNode Outgoing connections.\n");
            for (BpmnEdge edge : edgesToExist) {
                sb.append("--> Not present: Edge [" + edge.toString() + "].\n");
            }
            Assert.fail((String)sb.toString());
        }
    }

    protected void assertNodeContainsIncomingEdges(BpmnGraphNode node, BpmnEdge ... edges) {
        HashSet<BpmnEdge> edgesToExist = new HashSet<BpmnEdge>();
        for (BpmnEdge edge : edges) {
            edgesToExist.add(edge);
        }
        for (BpmnEdge edge : node.getInEdges()) {
            for (BpmnEdge be : edges) {
                if (!be.equals(edge)) continue;
                edgesToExist.remove(edge);
            }
        }
        if (!edgesToExist.isEmpty()) {
            StringBuffer sb = new StringBuffer("Not all Edges were present in GraphNode Incoming connections.\n");
            for (BpmnEdge edge : edgesToExist) {
                sb.append("--> Not present: Edge [" + edge.toString() + "].\n");
            }
            Assert.fail((String)sb.toString());
        }
    }
}

