/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bpmn.client.explorer;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.wires.bpmn.api.service.BpmnService;
import org.uberfire.ext.wires.bpmn.client.explorer.BpmnExplorerView;
import org.uberfire.ext.wires.bpmn.client.resources.i18n.BpmnEditorConstants;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
@WorkbenchScreen(identifier="BPMN Explorer")
public class BpmnExplorerPresenter {
    @Inject
    private Caller<BpmnService> service;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private BpmnExplorerView view;

    @OnStartup
    public void onStartup(PlaceRequest place) {
        ((BpmnService)this.service.call((RemoteCallback)new RemoteCallback<List<Path>>(){

            public void callback(List<Path> files) {
                BpmnExplorerPresenter.this.view.setContent(files);
            }
        })).listFiles();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return BpmnEditorConstants.INSTANCE.bpmnExplorerTitle();
    }

    @WorkbenchPartView
    public UberView<BpmnExplorerPresenter> getWidget() {
        return this.view;
    }

    public void openFile(Path file) {
        this.placeManager.goTo((PlaceRequest)new PathPlaceRequest(file));
    }
}

