/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client;

import org.jboss.errai.bus.client.api.BusLifecycleEvent;
import org.jboss.errai.bus.client.api.BusLifecycleListener;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.bus.client.api.TransportError;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.uberfire.client.WorkbenchBackendEntryPoint;
import org.uberfire.client.workbench.WorkbenchServicesProxy;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchBackendEntryPointTest {
    @Mock
    private Logger logger;
    @Mock
    private ClientMessageBus bus;
    @Mock
    private WorkbenchServicesProxy workbenchServices;
    @Mock
    private ErrorPopupPresenter errorPopupPresenter;

    @Test
    public void testErrorDisplay() {
        WorkbenchBackendEntryPoint workbenchBackendEntryPoint = new WorkbenchBackendEntryPoint(this.logger, this.bus, this.workbenchServices, this.errorPopupPresenter);
        ((WorkbenchServicesProxy)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                ParameterizedCommand obj = (ParameterizedCommand)args[0];
                obj.execute((Object)false);
                return null;
            }
        }).when((Object)this.workbenchServices)).isWorkbenchOnCluster((ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        workbenchBackendEntryPoint.postConstruct();
        workbenchBackendEntryPoint.init();
        ArgumentCaptor captor = ArgumentCaptor.forClass(BusLifecycleListener.class);
        ((ClientMessageBus)Mockito.verify((Object)this.bus)).addLifecycleListener((BusLifecycleListener)captor.capture());
        BusLifecycleListener listener = (BusLifecycleListener)captor.getValue();
        TransportError error = (TransportError)Mockito.mock(TransportError.class);
        BusLifecycleEvent event = new BusLifecycleEvent(this.bus, error);
        listener.busOffline(event);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).error(Mockito.anyString());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
        listener.busOffline(event);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).error(Mockito.anyString());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
        listener.busOnline(event);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).info(Mockito.anyString());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
        listener.busOffline(event);
        listener.busOffline(event);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)2))).error(Mockito.anyString());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)2))).showMessage(Mockito.anyString());
    }

    @Test
    public void testNoErrorDisplay() {
        WorkbenchBackendEntryPoint workbenchBackendEntryPoint = new WorkbenchBackendEntryPoint(this.logger, this.bus, this.workbenchServices, this.errorPopupPresenter);
        ((WorkbenchServicesProxy)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                ParameterizedCommand obj = (ParameterizedCommand)args[0];
                obj.execute((Object)true);
                return null;
            }
        }).when((Object)this.workbenchServices)).isWorkbenchOnCluster((ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        workbenchBackendEntryPoint.postConstruct();
        workbenchBackendEntryPoint.init();
        ArgumentCaptor captor = ArgumentCaptor.forClass(BusLifecycleListener.class);
        ((ClientMessageBus)Mockito.verify((Object)this.bus)).addLifecycleListener((BusLifecycleListener)captor.capture());
        BusLifecycleListener listener = (BusLifecycleListener)captor.getValue();
        TransportError error = (TransportError)Mockito.mock(TransportError.class);
        BusLifecycleEvent event = new BusLifecycleEvent(this.bus, error);
        listener.busOffline(event);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).error(Mockito.anyString());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        listener.busOffline(event);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).error(Mockito.anyString());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        listener.busOnline(event);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).info(Mockito.anyString());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        listener.busOffline(event);
        listener.busOffline(event);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)2))).error(Mockito.anyString());
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
    }
}

