/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.gwttest;

import com.google.gwt.junit.client.GWTTestCase;
import org.uberfire.client.workbench.widgets.panel.MaximizeToggleButton;
import org.uberfire.mvp.Command;
import org.uberfire.wbtest.testutil.CountingCommand;

public class MaximizeToggleButtonTest
extends GWTTestCase {
    MaximizeToggleButton maximizeButton;
    CountingCommand maximizeCommand = new CountingCommand();
    CountingCommand unmaximizeCommand = new CountingCommand();

    public String getModuleName() {
        return "org.uberfire.wbtest.UberFireClientGwtTest";
    }

    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        this.maximizeButton = new MaximizeToggleButton();
        this.maximizeButton.setMaximizeCommand((Command)this.maximizeCommand);
        this.maximizeButton.setUnmaximizeCommand((Command)this.unmaximizeCommand);
    }

    public void testMaximizeWhenClicked() throws Exception {
        this.maximizeButton.click();
        MaximizeToggleButtonTest.assertTrue((boolean)this.maximizeButton.isMaximized());
        MaximizeToggleButtonTest.assertEquals((int)1, (int)this.maximizeCommand.executeCount);
        MaximizeToggleButtonTest.assertEquals((int)0, (int)this.unmaximizeCommand.executeCount);
    }

    public void testUnaximizeWhenClickedAgain() throws Exception {
        this.maximizeButton.click();
        this.maximizeButton.click();
        MaximizeToggleButtonTest.assertFalse((boolean)this.maximizeButton.isMaximized());
        MaximizeToggleButtonTest.assertEquals((int)1, (int)this.maximizeCommand.executeCount);
        MaximizeToggleButtonTest.assertEquals((int)1, (int)this.unmaximizeCommand.executeCount);
    }

    public void testSetMaximizedDoesNotInvokeCommands() throws Exception {
        this.maximizeButton.setMaximized(true);
        this.maximizeButton.setMaximized(false);
        MaximizeToggleButtonTest.assertFalse((boolean)this.maximizeButton.isMaximized());
        MaximizeToggleButtonTest.assertEquals((int)0, (int)this.maximizeCommand.executeCount);
        MaximizeToggleButtonTest.assertEquals((int)0, (int)this.unmaximizeCommand.executeCount);
    }

    public void testSetMaximizedFromCallbackIsSafe() throws Exception {
        this.maximizeButton.setMaximizeCommand(new Command(){

            public void execute() {
                MaximizeToggleButtonTest.this.maximizeButton.setMaximized(true);
            }
        });
        this.maximizeButton.click();
        MaximizeToggleButtonTest.assertTrue((boolean)this.maximizeButton.isMaximized());
        MaximizeToggleButtonTest.assertEquals((int)0, (int)this.maximizeCommand.executeCount);
        MaximizeToggleButtonTest.assertEquals((int)0, (int)this.unmaximizeCommand.executeCount);
    }
}

