/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.uberfire.wbtest.client.panels.maximize.MaximizeTestPerspective;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;
import org.uberfire.wbtest.selenium.AbstractWorkbenchPanelWrapper;
import org.uberfire.wbtest.selenium.MaximizeTestScreenWrapper;
import org.uberfire.wbtest.selenium.MultiListPanelWrapper;
import org.uberfire.wbtest.selenium.MultiTabPanelWrapper;
import org.uberfire.wbtest.selenium.SeleniumConditions;
import org.uberfire.wbtest.selenium.SimplePanelWrapper;

public class MaximizePanelTest
extends AbstractSeleniumTest {
    private MultiTabPanelWrapper tabPanel;
    private MultiListPanelWrapper listPanel;
    private SimplePanelWrapper simplePanel;

    @Before
    public void setup() {
        this.driver.get(this.baseUrl + "#" + MaximizeTestPerspective.class.getName());
        this.tabPanel = new MultiTabPanelWrapper(this.driver, "MaximizeTestPerspective-tab");
        this.listPanel = new MultiListPanelWrapper(this.driver, "MaximizeTestPerspective-list");
        this.simplePanel = new SimplePanelWrapper(this.driver, "MaximizeTestPerspective-simple");
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
    }

    @Test
    public void maximizeButtonShouldWorkOnTabbedPanel() throws Exception {
        MaximizeTestScreenWrapper tabPanelScreen4 = new MaximizeTestScreenWrapper(this.driver, "4");
        Dimension reportedSizeBefore = tabPanelScreen4.getReportedSize();
        this.tabPanel.clickMaximizeButton();
        Dimension reportedSizeAfter = tabPanelScreen4.getReportedSize();
        this.assertBigger(reportedSizeBefore, reportedSizeAfter);
        this.assertObscuredBy(this.tabPanel, this.listPanel);
        this.assertObscuredBy(this.tabPanel, this.simplePanel);
    }

    @Test
    public void maximizeButtonShouldWorkOnListPanel() throws Exception {
        MaximizeTestScreenWrapper listPanelScreen2 = new MaximizeTestScreenWrapper(this.driver, "2");
        Dimension reportedSizeBefore = listPanelScreen2.getReportedSize();
        this.listPanel.clickMaximizeButton();
        Dimension reportedSizeAfter = listPanelScreen2.getReportedSize();
        this.assertBigger(reportedSizeBefore, reportedSizeAfter);
        this.assertObscuredBy(this.listPanel, this.tabPanel);
        this.assertObscuredBy(this.listPanel, this.simplePanel);
    }

    @Test
    public void maximizeButtonShouldWorkOnSimplePanel() throws Exception {
        MaximizeTestScreenWrapper simplePanelScreen5 = new MaximizeTestScreenWrapper(this.driver, "5");
        Dimension reportedSizeBefore = simplePanelScreen5.getReportedSize();
        this.simplePanel.clickMaximizeButton();
        Thread.sleep(3000L);
        Dimension reportedSizeAfter = simplePanelScreen5.getReportedSize();
        this.assertBigger(reportedSizeBefore, reportedSizeAfter);
        this.assertObscuredBy(this.simplePanel, this.tabPanel);
        this.assertObscuredBy(this.simplePanel, this.listPanel);
    }

    @Test
    public void maximizedTabPanelShouldTrackWindowSize() throws Exception {
        MaximizeTestScreenWrapper tabPanelScreen4 = new MaximizeTestScreenWrapper(this.driver, "4");
        this.tabPanel.clickMaximizeButton();
        Dimension originalMaximizedSize = tabPanelScreen4.getReportedSize();
        this.driver.manage().window().setSize(new Dimension(1050, 660));
        new WebDriverWait(this.driver, 5L).until(SeleniumConditions.reportedSizeIs(tabPanelScreen4, new Dimension(originalMaximizedSize.width + 50, originalMaximizedSize.height - 40)));
    }

    @Test
    public void maximizedListPanelShouldTrackWindowSize() throws Exception {
        MaximizeTestScreenWrapper listPanelScreen2 = new MaximizeTestScreenWrapper(this.driver, "2");
        this.listPanel.clickMaximizeButton();
        Dimension originalMaximizedSize = listPanelScreen2.getReportedSize();
        this.driver.manage().window().setSize(new Dimension(1050, 660));
        new WebDriverWait(this.driver, 5L).until(SeleniumConditions.reportedSizeIs(listPanelScreen2, new Dimension(originalMaximizedSize.width + 50, originalMaximizedSize.height - 40)));
    }

    private void assertBigger(Dimension before, Dimension after) {
        Assert.assertTrue((String)("Element did not grow in width. before=" + before + ", after=" + after), (before.width < after.width ? 1 : 0) != 0);
        Assert.assertTrue((String)("Element did not grow in height. before=" + before + ", after=" + after), (before.height < after.height ? 1 : 0) != 0);
    }

    private void assertObscuredBy(AbstractWorkbenchPanelWrapper big, AbstractWorkbenchPanelWrapper little) {
        Assert.assertTrue((String)("Smaller panel " + little.getLocation() + " " + little.getSize() + " is not obscured by " + big.getLocation() + big.getSize()), (boolean)little.isObscuredBy(big));
    }
}

