/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class MaximizeTestScreenWrapper {
    private final WebDriver driver;
    private final String id;

    public MaximizeTestScreenWrapper(WebDriver driver, String id) {
        this.driver = driver;
        this.id = "MaximizeTestScreen-" + id;
    }

    public WebElement find() {
        return this.driver.findElement(By.id((String)this.id));
    }

    public Dimension getActualSize() {
        WebElement element = this.find();
        return element.getSize();
    }

    public Dimension getReportedSize() {
        WebElement element = this.driver.findElement(By.id((String)(this.id + "-sizeLabel")));
        String text = element.getText();
        Matcher matcher = Pattern.compile("([0-9]+)x([0-9]+)").matcher(text);
        if (matcher.matches()) {
            return new Dimension(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
        }
        throw new IllegalStateException("Couldn't understand reported size \"" + text + "\"");
    }
}

