/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.uberfire.workbench.model.CompassPosition;

public class NestingScreenWrapper {
    private final WebDriver driver;
    private final String positionTag;
    private final WebElement element;
    private final Map<CompassPosition, Integer> childCounts = new HashMap<CompassPosition, Integer>();

    public NestingScreenWrapper(WebDriver driver, String positionTag) {
        this.driver = driver;
        this.positionTag = positionTag;
        this.element = driver.findElement(By.id((String)("gwt-debug-NestingScreen-" + positionTag)));
        if (this.element == null) {
            throw new IllegalStateException("NestingScreen " + positionTag + " not found!");
        }
    }

    public NestingScreenWrapper addChild(CompassPosition position) {
        WebElement button = this.element.findElement(By.className((String)position.name().toLowerCase()));
        button.click();
        Integer childCount = this.childCounts.get(position);
        if (childCount == null) {
            childCount = 0;
        }
        this.childCounts.put(position, childCount + 1);
        return new NestingScreenWrapper(this.driver, this.positionTag + position.name().charAt(0) + childCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStillInDom() {
        try {
            this.driver.manage().timeouts().implicitlyWait(10L, TimeUnit.MILLISECONDS);
            boolean bl = this.driver.findElements(By.id((String)("gwt-debug-NestingScreen-" + this.positionTag))).size() > 0;
            return bl;
        }
        finally {
            this.driver.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPanelStillInDom() {
        try {
            this.driver.manage().timeouts().implicitlyWait(10L, TimeUnit.MILLISECONDS);
            boolean bl = this.driver.findElements(By.id((String)("NestingScreenPanel-" + this.positionTag))).size() > 0;
            return bl;
        }
        finally {
            this.driver.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
        }
    }

    public Point getLocation() {
        return this.element.getLocation();
    }

    public Dimension getSize() {
        return this.element.getSize();
    }

    public void close() {
        this.element.findElement(By.className((String)"close")).click();
    }

    public WebElement getWebElement() {
        return this.element;
    }
}

