/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.ArrayList;
import java.util.Date;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.UserCookieEncoder;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebElement;
import org.uberfire.wbtest.client.security.InjectedUserScreen;
import org.uberfire.wbtest.client.security.SecurityContextInfoScreen;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;

public class UserCookieTest
extends AbstractSeleniumTest {
    @Before
    public void setup() {
        MappingContextSingleton.loadDynamicMarshallers();
    }

    @Test
    public void testGetInfoFromSecurityContext() throws Exception {
        User user = this.makeTestUser();
        String jsonUser = UserCookieEncoder.toCookieValue((User)user);
        this.driver.get(this.baseUrl + "blank.html");
        this.driver.manage().addCookie(new Cookie("errai-active-user", jsonUser, "/", new Date(System.currentTimeMillis() + 1440000L)));
        this.driver.get(this.baseUrl);
        this.waitForDefaultPerspective();
        this.driver.get(this.baseUrl + "#" + SecurityContextInfoScreen.class.getName());
        WebElement userLabel = this.driver.findElement(By.id((String)"gwt-debug-SecurityStatusScreen-userLabel"));
        Assert.assertEquals((Object)user.getIdentifier(), (Object)userLabel.getText());
        WebElement rolesLabel = this.driver.findElement(By.id((String)"gwt-debug-SecurityStatusScreen-rolesLabel"));
        Assert.assertEquals((Object)user.getRoles().toString(), (Object)rolesLabel.getText());
        WebElement groupsLabel = this.driver.findElement(By.id((String)"gwt-debug-SecurityStatusScreen-groupsLabel"));
        Assert.assertEquals((Object)user.getGroups().toString(), (Object)groupsLabel.getText());
    }

    @Test
    public void testGetInfoFromInjectedUser() throws Exception {
        User user = this.makeTestUser();
        String jsonUser = UserCookieEncoder.toCookieValue((User)user);
        this.driver.get(this.baseUrl + "blank.html");
        this.driver.manage().addCookie(new Cookie("errai-active-user", jsonUser, "/", new Date(System.currentTimeMillis() + 1440000L)));
        this.driver.get(this.baseUrl);
        this.waitForDefaultPerspective();
        this.driver.get(this.baseUrl + "#" + InjectedUserScreen.class.getName());
        WebElement userLabel = this.driver.findElement(By.id((String)"gwt-debug-SecurityStatusScreen-userLabel"));
        Assert.assertEquals((Object)user.getIdentifier(), (Object)userLabel.getText());
        WebElement rolesLabel = this.driver.findElement(By.id((String)"gwt-debug-SecurityStatusScreen-rolesLabel"));
        Assert.assertEquals((Object)user.getRoles().toString(), (Object)rolesLabel.getText());
        WebElement groupsLabel = this.driver.findElement(By.id((String)"gwt-debug-SecurityStatusScreen-groupsLabel"));
        Assert.assertEquals((Object)user.getGroups().toString(), (Object)groupsLabel.getText());
    }

    private User makeTestUser() {
        ArrayList<RoleImpl> roles = new ArrayList<RoleImpl>();
        roles.add(new RoleImpl("role-1"));
        ArrayList<GroupImpl> groups = new ArrayList<GroupImpl>();
        groups.add(new GroupImpl("group"));
        UserImpl user = new UserImpl("testing-user", roles, groups);
        return user;
    }
}

