/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.uberfire.commons.validation.PortablePreconditions;

public abstract class AbstractWorkbenchPanelWrapper {
    protected WebDriver driver;
    protected String panelId;

    public AbstractWorkbenchPanelWrapper(WebDriver driver, String panelId) {
        this.driver = (WebDriver)PortablePreconditions.checkNotNull((String)"driver", (Object)driver);
        this.panelId = (String)PortablePreconditions.checkNotNull((String)"panelId", (Object)panelId);
    }

    public void clickMaximizeButton() {
        WebElement button = this.driver.findElement(By.id((String)("gwt-debug-" + this.panelId + "-maximizeButton")));
        button.click();
    }

    public boolean isObscuredBy(AbstractWorkbenchPanelWrapper bigger) {
        Dimension mySize = this.getSize();
        Point myPos = this.getLocation();
        Dimension biggerSize = bigger.getSize();
        Point biggerPos = bigger.getLocation();
        return biggerPos.x <= myPos.x && biggerPos.y <= myPos.y && biggerSize.width >= mySize.width && biggerSize.height >= mySize.height;
    }

    public Dimension getSize() {
        return this.driver.findElement(By.id((String)this.panelId)).getSize();
    }

    public Point getLocation() {
        return this.driver.findElement(By.id((String)this.panelId)).getLocation();
    }
}

