/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.uberfire.wbtest.client.panels.docking.NestedDockingPanelPerspective;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;
import org.uberfire.wbtest.selenium.NestingScreenWrapper;
import org.uberfire.wbtest.selenium.UberAssertions;
import org.uberfire.workbench.model.CompassPosition;

@RunWith(value=Parameterized.class)
public class DockingPanelTest
extends AbstractSeleniumTest {
    @Parameterized.Parameter(value=0)
    public CompassPosition direction;

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({CompassPosition.NORTH}, {CompassPosition.SOUTH}, {CompassPosition.EAST}, {CompassPosition.WEST});
    }

    @Before
    public void goToDockingPerspective() {
        this.driver.get(this.baseUrl + "#" + NestedDockingPanelPerspective.class.getName());
    }

    @Test
    public void testAddAndRemovePanelRelativeToRoot() {
        NestingScreenWrapper root = new NestingScreenWrapper(this.driver, "root");
        NestingScreenWrapper childScreen = root.addChild(this.direction);
        Assert.assertTrue((boolean)childScreen.isStillInDom());
        Assert.assertTrue((boolean)childScreen.isPanelStillInDom());
        UberAssertions.assertRelativePosition(this.direction, root.getWebElement(), childScreen.getWebElement());
        childScreen.close();
        Assert.assertFalse((boolean)childScreen.isStillInDom());
        Assert.assertFalse((boolean)childScreen.isPanelStillInDom());
    }

    @Test
    public void testAddTwoPanelsToRootRemovingOldestFirst() {
        NestingScreenWrapper root = new NestingScreenWrapper(this.driver, "root");
        NestingScreenWrapper childScreen1 = root.addChild(this.direction);
        NestingScreenWrapper childScreen2 = root.addChild(this.direction);
        Assert.assertTrue((boolean)childScreen1.isStillInDom());
        Assert.assertTrue((boolean)childScreen1.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen2.isStillInDom());
        Assert.assertTrue((boolean)childScreen2.isPanelStillInDom());
        UberAssertions.assertRelativePosition(this.direction, root.getWebElement(), childScreen2.getWebElement());
        UberAssertions.assertRelativePosition(this.direction, childScreen2.getWebElement(), childScreen1.getWebElement());
        childScreen1.close();
        Assert.assertFalse((boolean)childScreen1.isStillInDom());
        Assert.assertFalse((boolean)childScreen1.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen2.isStillInDom());
        Assert.assertTrue((boolean)childScreen2.isPanelStillInDom());
        childScreen2.close();
        Assert.assertFalse((boolean)childScreen1.isStillInDom());
        Assert.assertFalse((boolean)childScreen1.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen2.isStillInDom());
        Assert.assertFalse((boolean)childScreen2.isPanelStillInDom());
    }

    @Test
    public void testAddTwoPanelsToRootRemovingNewestFirst() {
        NestingScreenWrapper root = new NestingScreenWrapper(this.driver, "root");
        NestingScreenWrapper childScreen1 = root.addChild(this.direction);
        NestingScreenWrapper childScreen2 = root.addChild(this.direction);
        Assert.assertTrue((boolean)childScreen1.isStillInDom());
        Assert.assertTrue((boolean)childScreen1.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen2.isStillInDom());
        Assert.assertTrue((boolean)childScreen2.isPanelStillInDom());
        childScreen2.close();
        Assert.assertTrue((boolean)childScreen1.isStillInDom());
        Assert.assertTrue((boolean)childScreen1.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen2.isStillInDom());
        Assert.assertFalse((boolean)childScreen2.isPanelStillInDom());
        childScreen1.close();
        Assert.assertFalse((boolean)childScreen1.isStillInDom());
        Assert.assertFalse((boolean)childScreen1.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen2.isStillInDom());
        Assert.assertFalse((boolean)childScreen2.isPanelStillInDom());
    }

    @Test
    public void testAddAndRemoveTwoPanelsAtOppositeEgdes() throws Exception {
        NestingScreenWrapper root = new NestingScreenWrapper(this.driver, "root");
        Dimension originalRootSize = root.getSize();
        Point originalRootLocation = root.getLocation();
        NestingScreenWrapper childScreen1 = root.addChild(this.direction);
        NestingScreenWrapper childScreen2 = root.addChild(this.direction);
        NestingScreenWrapper childScreen3 = root.addChild(DockingPanelTest.opposite(this.direction));
        NestingScreenWrapper childScreen4 = root.addChild(DockingPanelTest.opposite(this.direction));
        Assert.assertTrue((boolean)childScreen1.isStillInDom());
        Assert.assertTrue((boolean)childScreen1.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen2.isStillInDom());
        Assert.assertTrue((boolean)childScreen2.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen3.isStillInDom());
        Assert.assertTrue((boolean)childScreen3.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen4.isStillInDom());
        Assert.assertTrue((boolean)childScreen4.isPanelStillInDom());
        childScreen2.close();
        Assert.assertTrue((boolean)childScreen1.isStillInDom());
        Assert.assertTrue((boolean)childScreen1.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen2.isStillInDom());
        Assert.assertFalse((boolean)childScreen2.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen3.isStillInDom());
        Assert.assertTrue((boolean)childScreen3.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen4.isStillInDom());
        Assert.assertTrue((boolean)childScreen4.isPanelStillInDom());
        childScreen1.close();
        Assert.assertFalse((boolean)childScreen1.isStillInDom());
        Assert.assertFalse((boolean)childScreen1.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen2.isStillInDom());
        Assert.assertFalse((boolean)childScreen2.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen3.isStillInDom());
        Assert.assertTrue((boolean)childScreen3.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen4.isStillInDom());
        Assert.assertTrue((boolean)childScreen4.isPanelStillInDom());
        childScreen3.close();
        Assert.assertFalse((boolean)childScreen1.isStillInDom());
        Assert.assertFalse((boolean)childScreen1.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen2.isStillInDom());
        Assert.assertFalse((boolean)childScreen2.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen3.isStillInDom());
        Assert.assertFalse((boolean)childScreen3.isPanelStillInDom());
        Assert.assertTrue((boolean)childScreen4.isStillInDom());
        Assert.assertTrue((boolean)childScreen4.isPanelStillInDom());
        childScreen4.close();
        Assert.assertFalse((boolean)childScreen1.isStillInDom());
        Assert.assertFalse((boolean)childScreen1.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen2.isStillInDom());
        Assert.assertFalse((boolean)childScreen2.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen3.isStillInDom());
        Assert.assertFalse((boolean)childScreen3.isPanelStillInDom());
        Assert.assertFalse((boolean)childScreen4.isStillInDom());
        Assert.assertFalse((boolean)childScreen4.isPanelStillInDom());
        Assert.assertEquals((Object)originalRootSize, (Object)root.getSize());
        Assert.assertEquals((Object)originalRootLocation, (Object)root.getLocation());
    }

    @Test
    public void testLastOffAxisPanelSitsBetweenExistingPanels() throws Exception {
        NestingScreenWrapper root = new NestingScreenWrapper(this.driver, "root");
        NestingScreenWrapper onAxisChild1 = root.addChild(this.direction);
        NestingScreenWrapper onAxisChild2 = root.addChild(DockingPanelTest.opposite(this.direction));
        NestingScreenWrapper offAxisChild1 = root.addChild(DockingPanelTest.next(this.direction));
        NestingScreenWrapper offAxisChild2 = root.addChild(DockingPanelTest.next(DockingPanelTest.opposite(this.direction)));
        UberAssertions.assertRelativePosition(this.direction, offAxisChild1.getWebElement(), onAxisChild1.getWebElement());
        UberAssertions.assertRelativePosition(this.direction, offAxisChild2.getWebElement(), onAxisChild1.getWebElement());
        UberAssertions.assertRelativePosition(DockingPanelTest.opposite(this.direction), offAxisChild1.getWebElement(), onAxisChild2.getWebElement());
        UberAssertions.assertRelativePosition(DockingPanelTest.opposite(this.direction), offAxisChild2.getWebElement(), onAxisChild2.getWebElement());
    }

    static CompassPosition opposite(CompassPosition position) {
        switch (position) {
            case NORTH: {
                return CompassPosition.SOUTH;
            }
            case SOUTH: {
                return CompassPosition.NORTH;
            }
            case EAST: {
                return CompassPosition.WEST;
            }
            case WEST: {
                return CompassPosition.EAST;
            }
        }
        throw new IllegalArgumentException("Position " + position + " has no opposite.");
    }

    static CompassPosition next(CompassPosition position) {
        switch (position) {
            case NORTH: {
                return CompassPosition.EAST;
            }
            case EAST: {
                return CompassPosition.SOUTH;
            }
            case SOUTH: {
                return CompassPosition.WEST;
            }
            case WEST: {
                return CompassPosition.NORTH;
            }
        }
        throw new IllegalArgumentException("Position " + position + " is not a cardinal direction.");
    }
}

