/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.uberfire.wbtest.client.dnd.DragAndDropPerspective;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;
import org.uberfire.wbtest.selenium.UberAssertions;
import org.uberfire.workbench.model.CompassPosition;

public class DragAndDropTest
extends AbstractSeleniumTest {
    @Before
    public void setUpPerspective() {
        this.driver.get(this.baseUrl + "#" + DragAndDropPerspective.class.getName());
    }

    @Test
    public void testDragFromListPanelToSouthOfSelf() throws Exception {
        WebElement listDragHandle = this.driver.findElement(By.id((String)"gwt-debug-ListBar-title-DnD-2"));
        Assert.assertEquals((Object)"DnD-2", (Object)listDragHandle.getText());
        Actions dragAndDrop = new Actions(this.driver);
        dragAndDrop.clickAndHold(listDragHandle);
        dragAndDrop.moveByOffset(0, 50);
        dragAndDrop.perform();
        WebElement compassSouth = this.driver.findElement(By.id((String)"gwt-debug-CompassWidget-south"));
        dragAndDrop.click(compassSouth);
        dragAndDrop.perform();
        WebElement dnd1Screen = this.driver.findElement(By.id((String)"DragAndDropScreen-1"));
        WebElement dnd2Screen = this.driver.findElement(By.id((String)"DragAndDropScreen-2"));
        Assert.assertTrue((boolean)dnd1Screen.isDisplayed());
        UberAssertions.assertRelativePosition(CompassPosition.SOUTH, dnd1Screen, dnd2Screen);
    }

    @Test
    public void dragCompassShouldBeCenteredOverRootListTargetPanel() throws Exception {
        WebElement listDragHandle = this.driver.findElement(By.id((String)"gwt-debug-ListBar-title-DnD-2"));
        Assert.assertEquals((Object)"DnD-2", (Object)listDragHandle.getText());
        WebElement listPanel = this.driver.findElement(By.id((String)"DragAndDropPerspective-list"));
        Actions dragAndDrop = new Actions(this.driver);
        dragAndDrop.clickAndHold(listDragHandle);
        dragAndDrop.moveToElement(listPanel);
        dragAndDrop.perform();
        WebElement compassCenter = this.driver.findElement(By.id((String)"gwt-debug-CompassWidget-centre"));
        UberAssertions.assertCentered(listPanel, compassCenter);
    }

    @Test
    public void dragCompassShouldBeCenteredOverWestTabbedTargetPanel() throws Exception {
        WebElement listDragHandle = this.driver.findElement(By.id((String)"gwt-debug-ListBar-title-DnD-2"));
        Assert.assertEquals((Object)"DnD-2", (Object)listDragHandle.getText());
        WebElement tabPanel = this.driver.findElement(By.id((String)"DragAndDropPerspective-tab"));
        Actions dragAndDrop = new Actions(this.driver);
        dragAndDrop.clickAndHold(listDragHandle);
        dragAndDrop.moveToElement(tabPanel);
        dragAndDrop.perform();
        WebElement compassCenter = this.driver.findElement(By.id((String)"gwt-debug-CompassWidget-centre"));
        UberAssertions.assertCentered(tabPanel, compassCenter);
    }
}

