/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;

public class AbstractSeleniumTest {
    static final int WINDOW_HEIGHT = 700;
    static final int WINDOW_WIDTH = 1000;
    protected WebDriver driver;
    protected String baseUrl;
    protected boolean skipUncaughtExceptionCheck;

    @Before
    public final void setUp() throws Exception {
        this.driver = new FirefoxDriver();
        this.baseUrl = "http://localhost:8080/index.html";
        this.setNormalTimeout();
        this.driver.manage().window().setSize(new Dimension(1000, 700));
        this.driver.get(this.baseUrl);
        this.waitForDefaultPerspective();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public final void detectUncaughtExceptions() {
        try {
            WebElement alerterStatus;
            if (!this.skipUncaughtExceptionCheck && !(alerterStatus = this.driver.findElement(By.id((String)"UncaughtExceptionAlerter-statusLabel"))).getText().equals("0 uncaught exceptions")) {
                WebElement alerterLog = this.driver.findElement(By.id((String)"UncaughtExceptionAlerter-exceptionLog"));
                Assert.fail((String)("Uncaught exceptions detected:\n" + alerterLog.getAttribute("value") + "\nNote: to get Java line numbers in the stack trace, run like this:" + "\n    mvn clean verify -Dgwt.style=PRETTY -Dit.test=" + this.getClass().getSimpleName()));
            }
        }
        finally {
            this.driver.quit();
        }
    }

    protected void setNormalTimeout() {
        this.driver.manage().timeouts().implicitlyWait(30L, TimeUnit.SECONDS);
    }

    protected void waitForDefaultPerspective() {
        this.driver.findElement(By.id((String)"gwt-debug-DefaultScreenActivity"));
    }
}

