/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.wbtest.client.panels.custom.CustomPanelMakerScreen;
import org.uberfire.wbtest.client.perspective.ListPerspectiveActivity;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;
import org.uberfire.wbtest.selenium.CustomPanelScreenWrapper;
import org.uberfire.wbtest.selenium.ResizeWidgetWrapper;

public class CustomPanelTest
extends AbstractSeleniumTest {
    private CustomPanelScreenWrapper screen;

    @Before
    public void setupScreenObject() {
        this.driver.get(this.baseUrl + "#" + CustomPanelMakerScreen.class.getName());
        this.screen = new CustomPanelScreenWrapper(this.driver);
    }

    @Test
    public void activitiesLaunchedInCustomPanelsShouldAppear() throws Exception {
        String id = this.screen.createNewCustomPopup();
        Assert.assertTrue((boolean)this.screen.customPopupExistsInDom(id));
        Assert.assertEquals((long)1L, (long)this.screen.getLiveInstanceCount());
        Assert.assertEquals((long)1L, (long)this.screen.getTotalInstanceCount());
    }

    @Test
    public void activitiesLaunchedInCustomPanelsShouldDisposeWhenPlaceClosed() throws Exception {
        String id = this.screen.createNewCustomPopup();
        this.screen.closeLatestNewPopupUsingPlaceManager();
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.screen.customPopupExistsInDom(id));
        Assert.assertEquals((long)0L, (long)this.screen.getLiveInstanceCount());
        Assert.assertEquals((long)1L, (long)this.screen.getTotalInstanceCount());
    }

    @Test
    public void activitiesLaunchedInCustomPanelsShouldDisposeWhenRemovedFromDom() throws Exception {
        String id = this.screen.createNewCustomPopup();
        this.screen.closeLatestNewPopupByRemovingFromDom();
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.screen.customPopupExistsInDom(id));
        Assert.assertEquals((long)0L, (long)this.screen.getLiveInstanceCount());
        Assert.assertEquals((long)1L, (long)this.screen.getTotalInstanceCount());
    }

    @Test
    public void liveCustomPanelsShouldNotBreakPerspectiveSwitching() throws Exception {
        this.screen.createNewCustomPopup();
        this.driver.get(this.baseUrl + "#" + ListPerspectiveActivity.class.getName());
        this.driver.manage().timeouts().implicitlyWait(2L, TimeUnit.SECONDS);
        new ResizeWidgetWrapper(this.driver, "listPerspectiveDefault").find();
    }

    @Test
    public void removedCustomPanelsShouldNotBreakPerspectiveSwitching() throws Exception {
        this.screen.createNewCustomPopup();
        this.screen.closeLatestNewPopupUsingPlaceManager();
        this.driver.get(this.baseUrl + "#" + ListPerspectiveActivity.class.getName());
        this.driver.manage().timeouts().implicitlyWait(2L, TimeUnit.SECONDS);
        new ResizeWidgetWrapper(this.driver, "listPerspectiveDefault").find();
    }

    @Test
    public void customPanelContainersShouldBeReusable() throws Exception {
        String id = this.screen.createReusableCustomPopup();
        Assert.assertTrue((boolean)this.screen.customPopupExistsInDom(id));
        Assert.assertEquals((long)1L, (long)this.screen.getLiveInstanceCount());
        Assert.assertEquals((long)1L, (long)this.screen.getTotalInstanceCount());
        this.screen.closeReusablePopupUsingPlaceManager();
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.screen.customPopupExistsInDom(id));
        this.setNormalTimeout();
        Assert.assertEquals((long)0L, (long)this.screen.getLiveInstanceCount());
        Assert.assertEquals((long)1L, (long)this.screen.getTotalInstanceCount());
        id = this.screen.createReusableCustomPopup();
        Assert.assertTrue((boolean)this.screen.customPopupExistsInDom(id));
        Assert.assertEquals((long)1L, (long)this.screen.getLiveInstanceCount());
        Assert.assertEquals((long)2L, (long)this.screen.getTotalInstanceCount());
    }
}

