/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.wbtest.client.main.DefaultPerspectiveActivity;
import org.uberfire.wbtest.client.perspective.NonTransientMultiPanelPerspective;
import org.uberfire.wbtest.client.resize.ResizeTestScreenActivity;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;
import org.uberfire.wbtest.selenium.ResizeWidgetWrapper;
import org.uberfire.wbtest.selenium.TopHeaderWrapper;
import org.uberfire.workbench.model.CompassPosition;

public class PerspectiveSaveRestoreTest
extends AbstractSeleniumTest {
    @Before
    public void setUpPerspective() {
        this.driver.get(this.baseUrl + "#" + NonTransientMultiPanelPerspective.class.getName());
    }

    @Test
    public void testResizeWestPanel() throws Exception {
        WebElement splitterDragHandle = this.driver.findElement(By.className((String)"gwt-SplitLayoutPanel-HDragger"));
        Actions dragAndDrop = new Actions(this.driver);
        dragAndDrop.dragAndDropBy(splitterDragHandle, 123, 0);
        dragAndDrop.perform();
        ResizeWidgetWrapper westScreen = new ResizeWidgetWrapper(this.driver, "west");
        Dimension westScreenNewSize = westScreen.getReportedSize();
        this.driver.get(this.baseUrl + "#" + DefaultPerspectiveActivity.class.getName());
        this.waitForDefaultPerspective();
        this.driver.get(this.baseUrl + "#" + NonTransientMultiPanelPerspective.class.getName());
        ResizeWidgetWrapper westScreenReloaded = new ResizeWidgetWrapper(this.driver, "west");
        Assert.assertEquals((Object)westScreenNewSize, (Object)westScreenReloaded.getReportedSize());
    }

    @Test
    public void testAddNewPanel() throws Exception {
        TopHeaderWrapper topHeader = new TopHeaderWrapper(this.driver);
        topHeader.addPanelToRoot(CompassPosition.SOUTH, SimpleWorkbenchPanelPresenter.class, ResizeTestScreenActivity.class, "debugId", "newSouthPanel");
        this.driver.get(this.baseUrl + "#" + DefaultPerspectiveActivity.class.getName());
        this.waitForDefaultPerspective();
        this.driver.get(this.baseUrl + "#" + NonTransientMultiPanelPerspective.class.getName());
        ResizeWidgetWrapper newSouthScreen = new ResizeWidgetWrapper(this.driver, "newSouthPanel");
        Assert.assertNotNull((Object)newSouthScreen);
    }
}

